<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:variable name="dateFormat" select="string('yyyy-MM-dd')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::RCUK')"/>

	<xsl:template match="/">


		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>

			<metadata>
				<ROWS>
					<xsl:variable name="projectCode"
					              select="//*[local-name()='identifier' and ./@*[local-name()='type' and .='RCUK']]"/>
					<xsl:variable name="projectId"
					              select="concat($namespacePrefix, '::', $projectCode)"/>

					<xsl:variable name="sDate" select=".//*[local-name()='fund']/*[local-name()='start']"/>
					<xsl:variable name="eDate" select=".//*[local-name()='fund']/*[local-name()='end']"/>
					<xsl:variable name="startDate">
						<xsl:choose>
							<xsl:when test="contains($sDate, '+')">
								<xsl:value-of select="substring-before($sDate, '+')"/>
							</xsl:when>
							<xsl:when test="contains($sDate, 'Z')">
								<xsl:value-of select="substring-before($sDate, 'Z')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$sDate"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="endDate">
						<xsl:choose>
							<xsl:when test="contains($eDate, '+')">
								<xsl:value-of select="substring-before($eDate, '+')"/>
							</xsl:when>
							<xsl:when test="contains($eDate, 'Z')">
								<xsl:value-of select="substring-before($eDate, 'Z')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$eDate"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:variable name="personCode"
					              select=".//*[local-name()='person']/@*[local-name()='id']"/>
					<xsl:variable name="personId"
					              select="concat($namespacePrefix,'::',$personCode)"/>
					<xsl:variable name="funding" select=".//*[local-name()='funder']/name"/>
					<xsl:variable name="fundingId">
							<xsl:if test="string-length($funding) > 0">
								<xsl:value-of select="concat($funderID ,'::' , .//*[local-name()='funder']/name)"/>
							</xsl:if>
							<xsl:otherwise><xsl:value-of select="$funderID"/></xsl:otherwise>
					</xsl:variable>

					<ROW table="projects">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="code">
							<xsl:value-of select="$projectCode"/>
						</FIELD>
						<FIELD name="title">
							<xsl:value-of select=".//*[local-name()='title']"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$startDate"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$endDate"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="optional1">
							<xsl:value-of
									select="concat(.//*[local-name()='valuePounds']/@*[local-name()='amount'], ' ', .//*[local-name()='valuePounds']/@*[local-name()='currencyCode'])"/>
						</FIELD>

						<xsl:variable name="personSurname" select="normalize-space(.//*[local-name()='surname'])"/>
						<xsl:variable name="personFirstName" select="normalize-space(.//*[local-name()='firstName'])"/>
						<xsl:variable name="contactfullname">
							<xsl:choose>
								<xsl:when test="string-length($personFirstName) &gt; 0 and string-length($personSurname) &gt; 0">
									<xsl:value-of select="normalize-space(concat($personSurname, ', ', $personFirstName))"/>
								</xsl:when>
								<xsl:when test="string-length($personFirstName) &gt; 0">
									<xsl:value-of select="$personFirstName"/>
								</xsl:when>
								<xsl:when test="string-length($personSurname) &gt; 0">
									<xsl:value-of select="$personSurname"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="''"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="string-length($contactfullname) &gt; 0">
							<FIELD name="contactfullname">
								<xsl:value-of select="$contactfullname"/>
							</FIELD>
						</xsl:if>
					</ROW>

					<ROW table="project_fundingpath">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
						</FIELD>
						<FIELD name="funding">
							<xsl:value-of select="$fundingId"/>
						</FIELD>
						<FIELD name="project">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$startDate"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$endDate"/>
						</FIELD>
					</ROW>

					<xsl:for-each select=".//pp-org">
						<xsl:variable name="organizationId" select="concat($namespacePrefix, '::', normalize-space(./id))"/>
						<xsl:variable name="country" select="./country"/>
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$organizationId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$organizationId"/>
							</FIELD>
							<FIELD name="legalname">
								<xsl:value-of select="./name"/>
							</FIELD>

							<xsl:if test="string-length($country) &gt; 0">
								<FIELD name="countryclass">
									<xsl:value-of select="$country"/>
								</FIELD>
								<FIELD name="countryscheme">dnet:countries</FIELD>
							</xsl:if>

							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						</ROW>
						<ROW table="project_organization">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select='concat($projectId, "@@", $organizationId)'/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="resporganization">
								<xsl:value-of select="$organizationId"/>
							</FIELD>

							<FIELD name="semanticclass">participant</FIELD>
							<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
						</ROW>

					</xsl:for-each>

					<xsl:variable name="leadOrgId"
					              select="concat($namespacePrefix, '::', normalize-space(.//ld-org/id))"/>
					<ROW table="organizations">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$leadOrgId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$leadOrgId"/>
						</FIELD>
						<FIELD name="legalname">
							<xsl:value-of select=".//ld-org/name"/>
						</FIELD>
						<xsl:variable name="country" select=".//ld-org/country"/>
						<xsl:if test="string-length($country) &gt; 0">
							<FIELD name="countryclass">
								<xsl:value-of select="$country"/>
							</FIELD>
							<FIELD name="countryscheme">dnet:countries</FIELD>
						</xsl:if>

						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
					</ROW>

					<ROW table="project_organization">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select='concat($projectId, "@@", $leadOrgId)'/>
						</FIELD>
						<FIELD name="project">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="resporganization">
							<xsl:value-of select="$leadOrgId"/>
						</FIELD>
						<FIELD name="participantnumber" type="int">1</FIELD>
						<FIELD name="semanticclass">coordinator</FIELD>
						<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
					</ROW>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
