<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="SELECT_MODE"/>
	</ARCS>
</NODE>

 <NODE name="SELECT_MODE" type="Selection">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="selection" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT_REFRESH" name="REFRESH" />
		<ARC to="PREPARE_INCREMENTAL" name="INCREMENTAL" />
	</ARCS>
</NODE>

<NODE name="COLLECT_REFRESH" type="CollectRecords">
	<DESCRIPTION>Start Harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="MD_BUILDER_REFRESH"/>
	</ARCS>
</NODE>

<NODE name="MD_BUILDER_REFRESH" type="OpenaireMdBuilder">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="false" type="boolean" name="inferred" managedBy="system">false</PARAM>
		<PARAM required="false" type="boolean" name="deletedbyinference" managedBy="system">false</PARAM>
		<PARAM required="false" type="string" name="inferenceprovenance" managedBy="system"></PARAM>
		<PARAM required="false" type="string" name="trust" managedBy="user">0.9</PARAM>
		<PARAM required="false" type="string" name="provenanceactionclassname" managedBy="system">sysimport:crosswalk:datasetarchive</PARAM>
		<PARAM required="false" type="string" name="provenanceactionclassid" managedBy="system">sysimport:crosswalk:datasetarchive</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE_REFRESH"/>
	</ARCS>
</NODE>

<NODE name="STORE_REFRESH" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_INCREMENTAL" type="FindDateRangeForIncrementalHarvesting">
	<DESCRIPTION>Find Date Range For Incremental Harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="fromDateParam" managedBy="system">FROM_DATE</PARAM>
		<PARAM required="true" type="string" name="untilDateParam" managedBy="system">UNTIL_DATE</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT_INCREMENTAL"/>
	</ARCS>
</NODE>

<NODE name="COLLECT_INCREMENTAL" type="DateRangeCollectRecords">
	<DESCRIPTION>Start incremental harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="fromDateParam" managedBy="system">FROM_DATE</PARAM>
		<PARAM required="true" type="string" name="untilDateParam" managedBy="system">UNTIL_DATE</PARAM>
		<PARAM required="false" type="string" name="overrideFrom" managedBy="user"></PARAM>
        <PARAM required="false" type="string" name="overrideUntil" managedBy="user"></PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="MD_BUILDER_INCREMENTAL"/>
	</ARCS>
</NODE>

<NODE name="MD_BUILDER_INCREMENTAL" type="OpenaireMdBuilder">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="false" type="boolean" name="inferred" managedBy="system">false</PARAM>
		<PARAM required="false" type="boolean" name="deletedbyinference" managedBy="system">false</PARAM>
		<PARAM required="false" type="string" name="inferenceprovenance" managedBy="system"></PARAM>
		<PARAM required="false" type="string" name="trust" managedBy="system">0.9</PARAM>
		<PARAM required="false" type="string" name="provenanceactionclassname" managedBy="system">sysimport:crosswalk:datasetarchive</PARAM>
		<PARAM required="false" type="string" name="provenanceactionclassid" managedBy="system">sysimport:crosswalk:datasetarchive</PARAM>		
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE_INCREMENTAL"/>
	</ARCS>
</NODE>

<NODE name="STORE_INCREMENTAL" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records incrementally</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">INCREMENTAL</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_collection_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_collection_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_collection_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>


