<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<xsl:variable name="oName" select="normalize-space(//column[./@name='1'])"/>

		<xsl:choose>
			<xsl:when test="string-length($oName) &gt; 0">
				<record>
					<xsl:copy-of select=".//*[local-name()='header']"/>
					<metadata>
						<xsl:variable name="rid" select="normalize-space(//column[./@name='journalid'])"/>
						<xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
						<xsl:variable name="namespacePrefix" select='format-number($rid, "00000")'/>

						<ROWS>
							<ROW table="dsm_datasources">
								<FIELD name="id">
									<xsl:value-of select="$datasourceId"/>
								</FIELD>
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$datasourceId"/>
								</FIELD>
								<FIELD name="officialname">
									<xsl:value-of select="$oName"/>
								</FIELD>
								<FIELD name="englishname">
									<xsl:value-of select="$oName"/>
								</FIELD>
								<FIELD name="od_contenttypes">
									<xsl:value-of select="string('Journal articles')"/>
								</FIELD>
								<FIELD name="websiteurl">
									<xsl:value-of select="normalize-space(//column[./@name='2'])"/>
								</FIELD>
								<FIELD name="namespaceprefix">
									<xsl:value-of select="concat('irdb___',$namespacePrefix)"/>
								</FIELD>
								<FIELD name="typology">pubsrepository::journal</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceaction">sysimport:crosswalk:entityregistry</FIELD>
							</ROW>
						</ROWS>
					</metadata>
				</record>
			</xsl:when>
			<xsl:otherwise>
				<JUNK/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
