package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.util.List;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateFETH2020ContextJobNode extends SimpleJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(GenerateFETH2020ContextJobNode.class);
	private String eprParam;
	private ResultsetProgressProvider progressProvider;
	@Resource
	private ResultSetClientFactory resultSetClientFactory;
	@Resource
	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	public ProgressProvider getProgressProvider() {
		return this.progressProvider;
	}

	@Override
	protected String execute(NodeToken token) throws Exception {
		final String epr = token.getEnv().getAttribute(eprParam);

		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);

		final Iterable<String> iter = resultSetClientFactory.getClient(progressProvider.getEpr());

		BuildH2020FETTaxonomy builder = new BuildH2020FETTaxonomy();
		builder.setIterator(iter.iterator());
		String taxonomy = builder.parseProjects();
		final String xquery = "for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') "
				+ "where $x//CONFIGURATION/context[@id='fet-h2020'] return $x//RESOURCE_IDENTIFIER/@value/string()";
		List<String> list = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
		if (list.isEmpty()) {
			registerProfile(taxonomy);
		} else {
			deleteProfile(list.get(0));
			registerProfile(taxonomy);
		}
		return Arc.DEFAULT_ARC;
	}

	private void registerProfile(String profile) throws ISRegistryException {
		log.info("registering fet-h2020 profile");
		ISRegistryService is = serviceLocator.getService(ISRegistryService.class);
		String id = is.registerProfile(profile);
		log.info("Generating profile with id " + id);
	}

	private void deleteProfile(String profId) throws ISRegistryException {
		log.info("deleting fet-h2020 profile with id " + profId);
		ISRegistryService is = serviceLocator.getService(ISRegistryService.class);
		is.deleteProfile(profId);
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public void setProgressProvider(final ResultsetProgressProvider progressProvider) {
		this.progressProvider = progressProvider;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

}