<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oaa="http://namespace.openaire.eu/oaa"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:dnet="eu.dnetlib.miscutils.functional.hash.Hashing"
                xmlns:clean="eu.dnetlib.msro.openaireplus.utils.CleaningXsltFunctions"
                version="1.0"
                exclude-result-prefixes="xsl dnet oaa fn  clean fn">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">

		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:variable name="originalId" select="//*[local-name()='column' and ./@name='ISSN']"/>


					<xsl:variable name="id" select="concat($namespacePrefix,'::', $originalId)"/>

					<ROW table="doaj_temp_journal">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="journalname">
							<xsl:value-of select=".//*[local-name()='column' and ./@name='Title']"/>
						</FIELD>
						<FIELD name="issn">
							<xsl:value-of select="//*[local-name()='column' and ./@name='ISSN']"/>
						</FIELD>
						<FIELD name="oa_source_id">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>

	</xsl:template>
</xsl:stylesheet>
