/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IteratorOnQueue<T>
implements Iterator<T> {
    private static final Log log = LogFactory.getLog(IteratorOnQueue.class);
    private final BlockingQueue<T> inputQueue;
    private T currentItem;
    private T endQueue;

    public IteratorOnQueue(BlockingQueue<T> inputQueue, T endQueue) {
        this.inputQueue = inputQueue;
        this.endQueue = endQueue;
        try {
            this.currentItem = this.inputQueue.take();
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentItem != this.endQueue;
    }

    @Override
    public T next() {
        T previous = this.currentItem;
        try {
            this.currentItem = this.inputQueue.take();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return previous;
    }

    @Override
    public void remove() {
    }
}

