/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.message;

import eu.dnetlib.message.Message;
import eu.dnetlib.message.MessageManager;
import eu.dnetlib.message.MessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DnetMessageManager {
    private static final Log log = LogFactory.getLog(DnetMessageManager.class);
    private MessageManager manager;
    private LinkedBlockingQueue<Message> messages = new LinkedBlockingQueue();
    private final Map<String, Message> onGonginMessages = new HashMap<String, Message>();
    private final Map<String, List<Message>> reportMessages = new HashMap<String, List<Message>>();
    private String messageQueueServer;
    private String username;
    private String password;

    private String createReportId(String wfId, String jobName) {
        return String.format("%s::%s", wfId, jobName);
    }

    public void startListeningMessage() throws Exception {
        if (this.manager == null) {
            this.manager = new MessageManager(this.messageQueueServer, this.username, this.password, this.messages);
            this.manager.startConsumingMessage("dev_ongoing", true, false);
            this.manager.startConsumingMessage("dev_report", true, false);
            Runnable r = () -> {
                while (true) {
                    try {
                        Map<String, Object> map;
                        Message currentMessage = this.messages.take();
                        if (currentMessage.getType() == MessageType.ONGOING) {
                            map = this.onGonginMessages;
                            synchronized (map) {
                                this.onGonginMessages.put(currentMessage.getWorkflowId(), currentMessage);
                                continue;
                            }
                        }
                        map = this.reportMessages;
                        synchronized (map) {
                            if (!this.reportMessages.containsKey(currentMessage.getWorkflowId())) {
                                this.reportMessages.put(currentMessage.getWorkflowId(), new ArrayList());
                            }
                            this.reportMessages.get(currentMessage.getWorkflowId()).add(currentMessage);
                        }
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"An error occured on retrieving messages from the blocking queue", (Throwable)e);
                        throw new RuntimeException("An error occured on retrieving messages from the blocking queue", e);
                    }
                }
            };
            new Thread(r).start();
        }
    }

    public List<Message> getReport(String workflowId) {
        return this.getMessages(this.reportMessages, workflowId);
    }

    private List<Message> getMessages(Map<String, List<Message>> messageMap, String reportId) {
        if (messageMap.containsKey(reportId)) {
            List<Message> m = messageMap.get(reportId);
            messageMap.remove(reportId);
            return m;
        }
        return null;
    }

    private Message getMessage(Map<String, Message> messageMap, String reportId) {
        if (messageMap.containsKey(reportId)) {
            Message m = messageMap.get(reportId);
            messageMap.remove(reportId);
            return m;
        }
        return null;
    }

    public Message getOnGoingMessages(String workflowId) {
        return this.getMessage(this.onGonginMessages, workflowId);
    }

    public String getMessageQueueServer() {
        return this.messageQueueServer;
    }

    @Required
    public void setMessageQueueServer(String messageQueueServer) {
        this.messageQueueServer = messageQueueServer;
    }

    public String getUsername() {
        return this.username;
    }

    @Required
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @Required
    public void setPassword(String password) {
        this.password = password;
    }
}

