/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.manager.common.model.MDStoreWithInfo;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class MDStoreToApiExtraFieldHadoopJobNode
extends SimpleJobNode {
    private String mdId;
    private String datasourceId;
    private String datasourceInterface;
    private String extraFieldForTotal;
    private String extraFieldForDate;
    private String extraFieldForMdId;
    private String mdStoreManagerUrl;
    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;
    private static final Log log = LogFactory.getLog(MDStoreToApiExtraFieldHadoopJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        String url = this.getMdStoreManagerUrl() + "/mdstore/{mdId}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mdId", this.getMdId());
        URI uri = UriComponentsBuilder.fromUriString((String)url).buildAndExpand(params).toUri();
        RestTemplate restTemplate = new RestTemplate();
        MDStoreWithInfo mdstore = (MDStoreWithInfo)restTemplate.getForObject(uri, MDStoreWithInfo.class);
        int size = Math.toIntExact(mdstore.getSize());
        Date date = mdstore.getLastUpdate();
        if (this.extraFieldForTotal.equals("last_collection_total")) {
            this.dsManager.setLastCollectionInfo(this.datasourceId, this.datasourceInterface, this.mdId, Integer.valueOf(size), date);
        } else if (this.extraFieldForTotal.equals("last_aggregation_total")) {
            this.dsManager.setLastAggregationInfo(this.datasourceId, this.datasourceInterface, this.mdId, Integer.valueOf(size), date);
        } else {
            log.warn((Object)("Invalid field for total: " + this.extraFieldForTotal));
        }
        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getExtraFieldForTotal() {
        return this.extraFieldForTotal;
    }

    public void setExtraFieldForTotal(String extraFieldForTotal) {
        this.extraFieldForTotal = extraFieldForTotal;
    }

    public String getExtraFieldForDate() {
        return this.extraFieldForDate;
    }

    public void setExtraFieldForDate(String extraFieldForDate) {
        this.extraFieldForDate = extraFieldForDate;
    }

    public String getExtraFieldForMdId() {
        return this.extraFieldForMdId;
    }

    public void setExtraFieldForMdId(String extraFieldForMdId) {
        this.extraFieldForMdId = extraFieldForMdId;
    }

    public String getMdStoreManagerUrl() {
        return this.mdStoreManagerUrl;
    }

    public void setMdStoreManagerUrl(String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }
}

