/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareEnvTransformHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareEnvTransformHadoopJobNode.class);
    private String hdfsBasePath;
    private String ruleId;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        String reading_mdId = token.getEnv().getAttribute("reading_mdId");
        String reading_versionId = token.getEnv().getAttribute("reading_versionId");
        String writing_mdId = token.getEnv().getAttribute("mdId");
        String writing_versionId = token.getEnv().getAttribute("versionId");
        String hdfsNativePath = String.format("%s/%s/%s/store", this.hdfsBasePath, reading_mdId, reading_versionId);
        String hdfsTransformedPath = String.format("%s/%s/%s/store", this.hdfsBasePath, writing_mdId, writing_versionId);
        String trRule = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(this.getRuleId());
        token.getEnv().setAttribute("timestamp", "" + System.currentTimeMillis());
        token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
        token.getEnv().setAttribute("mdstoreInputPath", hdfsNativePath);
        token.getEnv().setAttribute("mdstoreOutputPath", hdfsTransformedPath);
        token.getEnv().setAttribute("transformationRule", DHPUtils.compressString((String)trRule));
        return Arc.DEFAULT_ARC;
    }

    public String getHdfsBasePath() {
        return this.hdfsBasePath;
    }

    public void setHdfsBasePath(String hdfsBasePath) {
        this.hdfsBasePath = hdfsBasePath;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

