package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.List;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IncrementalTransformationJobNode extends IncrementalOperationJobNode {

    private static final Log log = LogFactory.getLog(IncrementalTransformationJobNode.class);

    @Autowired
    private UniqueServiceLocator locator;

    private static final DateUtils dateUtils = new DateUtils();

    @Override
    protected boolean forceRefresh(final NodeToken nodeToken, final Long lastSuccessStartDate, final String currentWfProfileId) throws Exception {
        if (lastSuccessStartDate < 0) {
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Last success start date < 0, transformation forced to REFRESH");
            nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
            return true;
        }
        String trRuleId = getTransformationId(currentWfProfileId);
        final long lastUpdateDate = getLastTransformationRuleUpdate(trRuleId);
        log.info(String.format("Last update date of the transformation rule with id %s is %s", trRuleId, DateUtils.calculate_ISO8601(lastUpdateDate)));

        if (lastUpdateDate > lastSuccessStartDate) {
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Transformation Rule has been updated, transformation forced to REFRESH");
            nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
            return true;
        }
        return false;
    }





    private String getTransformationId(final String workflowId) throws ISLookUpException {

        final String query="for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' " +
                "return $x//PARAM[./@category='TRANSFORMATION_RULE_ID']/text()";
        final ISLookUpService lookUpService = locator.getService(ISLookUpService.class);
        final String queryInstance = String.format(query, workflowId);
        log.debug("Query to find the Transformation Rule");
        List<String> transformationId = lookUpService.quickSearchProfile(queryInstance);
        if(transformationId== null || transformationId.isEmpty())
            throw new RuntimeException("Error unable to find the Transformation rule ID on workflow profile "+workflowId);
        return transformationId.get(0);
    }

    private Long getLastTransformationRuleUpdate(final String trId) throws ISLookUpException {
        final String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//DATE_OF_CREATION/@value/string()";
        log.debug("retrieve creation date from transformation ID "+trId);
        final ISLookUpService lookUpService = locator.getService(ISLookUpService.class);
        final String queryInstance = String.format(query, trId);
        log.debug("Query to find the Transformation Rule");
        List<String> currentDate = lookUpService.quickSearchProfile(queryInstance);
        if(currentDate== null || currentDate.isEmpty())
            throw new RuntimeException("Error unable to find the creation date of the  Transformation rule "+trId);
        return dateUtils.parse(currentDate.get(0)).getTime();
    }

}
