package eu.dnetlib.msro.openaireplus.workflows.nodes.propagation.communitytoresult;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.Type;
import java.util.List;

public class LoadCommunityIdsListJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(LoadCommunityIdsListJobNode.class);

    @Autowired
    private UniqueServiceLocator serviceLocator;

    private String xquery;

    private String communityIdParam;

    public String getCommunityIdParam() {
        return communityIdParam;
    }

    public void setCommunityIdParam(String communityIdParam) {
        this.communityIdParam = communityIdParam;
    }

    public UniqueServiceLocator getServiceLocator() {
        return serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }


    @Override
    protected String execute(final NodeToken token) throws Exception {

        final List<String> res = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());
        Type listType = new TypeToken<List<String>>() {}.getType();

        token.getEnv().setAttribute(getCommunityIdParam(),new Gson().toJson(res,listType));

        return Arc.DEFAULT_ARC;
    }

    public String getXquery() {
        log.debug(xquery);
        return xquery;
    }

    public void setXquery(final String xquery) {
        this.xquery = xquery;

    }



}
