/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FindInvalidMetaWorkflowsJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private static final Log log = LogFactory.getLog(FindInvalidMetaWorkflowsJobNode.class);
    private boolean deleteInvalidProfiles = false;

    protected String execute(NodeToken token) throws Exception {
        ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        String q1 = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')\nlet $id := $x//RESOURCE_IDENTIFIER/@value\nfor $api in $x//INTERFACE/@id\nreturn concat($id,'|',$api)";
        String q2 = "for $x in collection(' /db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') \nwhere $x//DATAPROVIDER/@id and $x//DATAPROVIDER/@interface\nreturn concat($x//RESOURCE_IDENTIFIER/@value,'@@@',$x//DATAPROVIDER/@id,'|',$x//DATAPROVIDER/@interface)";
        HashSet valids = new HashSet(lookup.quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')\nlet $id := $x//RESOURCE_IDENTIFIER/@value\nfor $api in $x//INTERFACE/@id\nreturn concat($id,'|',$api)"));
        int count = 0;
        int countInvalids = 0;
        int countDeleted = 0;
        for (String s : lookup.quickSearchProfile("for $x in collection(' /db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') \nwhere $x//DATAPROVIDER/@id and $x//DATAPROVIDER/@interface\nreturn concat($x//RESOURCE_IDENTIFIER/@value,'@@@',$x//DATAPROVIDER/@id,'|',$x//DATAPROVIDER/@interface)")) {
            ++count;
            String metaWfId = StringUtils.substringBefore((String)s, (String)"@@@");
            String dsapi = StringUtils.substringAfter((String)s, (String)"@@@");
            if (valids.contains(dsapi)) continue;
            log.warn((Object)("Invalid metaWf: " + metaWfId));
            ++countInvalids;
            if (!this.deleteInvalidProfiles) continue;
            registry.deleteProfile(metaWfId);
            log.info((Object)" -- Deleted");
            ++countDeleted;
        }
        token.getEnv().setAttribute("mainlog:total", (Object)count);
        token.getEnv().setAttribute("mainlog:invalid", (Object)countInvalids);
        token.getEnv().setAttribute("mainlog:deleted", (Object)countDeleted);
        return Arc.DEFAULT_ARC;
    }

    public boolean isDeleteInvalidProfiles() {
        return this.deleteInvalidProfiles;
    }

    public void setDeleteInvalidProfiles(boolean deleteInvalidProfiles) {
        this.deleteInvalidProfiles = deleteInvalidProfiles;
    }
}

