package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.manager.common.model.MDStoreVersion;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class StartReadingMDStoreJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(StartReadingMDStoreJobNode.class);

    private String mdId;

    /* Spring managed params */
    private String mdStoreManagerUrl;

    @Override
    protected String execute(final NodeToken token) throws Exception {
        final String url = getMdStoreManagerUrl() + "/mdstore/{mdId}/startReading";

        final Map<String, Object> params = new HashMap<>();
        params.put("mdId", getMdId());

        final URI uri = UriComponentsBuilder.fromUriString(url)
                .buildAndExpand(params)
                .toUri();

        final RestTemplate restTemplate = new RestTemplate();
        final MDStoreVersion version = restTemplate.getForObject(uri, MDStoreVersion.class);

        log.info("mdstore version ready to read " + version.getId());

        token.getEnv().setAttribute("reading_mdId", mdId);
        token.getEnv().setAttribute("reading_versionId", version.getId());

        return Arc.DEFAULT_ARC;
    }

    public String getMdStoreManagerUrl() {
        return mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }

    public String getMdId() {
        return mdId;
    }

    public void setMdId(final String mdId) {
        this.mdId = mdId;
    }

}
