<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="2.0"
                exclude-result-prefixes="fn">

    <xsl:variable name="namespacePrefix" select="string('miur________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::MIUR')"/>

    <xsl:template match="/">
        <fundings>
            <fundingtree>
                <funder>
                    <id>
                        <xsl:value-of select="$funderID"/>
                    </id>
                    <shortname>MIUR</shortname>
                    <name>Ministero dell'Istruzione dell'Università e della Ricerca</name>
                    <jurisdiction>IT</jurisdiction>
                </funder>
                <xsl:variable name="stream">
                    <xsl:value-of select="translate(.//column[@name = 'FUNDING_STREAM'],' ','')"/>
                </xsl:variable>
                <funding_level_0>
                    <id>
                        <xsl:value-of select="concat($funderID, '::',$stream)"/>
                    </id>
                    <name><xsl:value-of select=".//column[@name='FUNDING_STREAM']"/></name>
                    <description><xsl:value-of select=".//column[@name='FUNDING_STREAM']"/></description>
                    <parent/>
                    <class>
                        <xsl:value-of select="concat('miur:',fn:lower-case($stream),'fundings')"/>
                    </class>
                </funding_level_0>
            </fundingtree>
        </fundings>
    </xsl:template>

</xsl:stylesheet>