<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="START_READING"/>
	</ARCS>
</NODE>

<NODE name="START_READING" type="StartReadingMDStore">
	<DESCRIPTION>Start reading Hadoop MD Store</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_STORE_VERSION"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_STORE_VERSION" type="PrepareMDStoreVersion">
	<DESCRIPTION>Prepare a new MdStore Version</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
        <ARC to="PREPARE_ENV_TRANSFORMATION"/>
    </ARCS>
</NODE>
<NODE name="PREPARE_ENV_TRANSFORMATION" type="PrepareEnvTransformHadoopJobNode">
    <DESCRIPTION>Retrieve all the parameters needed to run the transformation workflow</DESCRIPTION>
    <PARAMETERS>
        <PARAM category="TRANSFORMATION_RULE_ID" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" managedBy="user" name="ruleId" required="true" type="string"></PARAM>
        <PARAM managedBy="user" name="hdfsBasePath" required="true" type="string"></PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="TRANSFORM_HADOOP"/>
    </ARCS>
</NODE>
<NODE name="TRANSFORM_HADOOP" type="SubmitDnetHadoopJobNode">
    <DESCRIPTION>Start the Hadoop Job</DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="system" name="hadoopJob" required="true" type="string">dnetHadoopTrasnformation</PARAM>
        <PARAM managedBy="user" name="cluster" required="true" type="string">DHP</PARAM>
        <PARAM managedBy="system" name="envParams" required="true" type="string">
            {
                "mdstoreInputPath":"mdstoreInputPath",
                "mdstoreOutputPath":"mdstoreOutputPath",
                "transformationRule":"transformationRule",
                "timestamp":"timestamp",
                "workflowId":"workflowId"
            }
        </PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="COMMIT_VERSION"/>
        <ARC name="abort" to="ABORT_VERSION"/>
    </ARCS>
</NODE>
<NODE name="COMMIT_VERSION" type="CommitMDStoreVersion">
    <DESCRIPTION>Commit the mdstore version</DESCRIPTION>
    <PARAMETERS/>
    <ARCS>
        <ARC to="END_READING"/>
    </ARCS>
</NODE>
<NODE name="END_READING" type="EndReadingMDStore">
    <DESCRIPTION>End reading Hadoop MD Store</DESCRIPTION>
    <PARAMETERS/>
    <ARCS>
        <ARC to="UPDATE_INFO"/>
    </ARCS>
</NODE>
<NODE name="ABORT_VERSION" type="AbortMDStoreVersion">
    <DESCRIPTION>Abort the mdstore version</DESCRIPTION>
    <PARAMETERS/>
    <ARCS>
        <ARC to="END_READING_ABORT"/>
    </ARCS>
</NODE>
<NODE name="END_READING_ABORT" type="EndReadingMDStore">
    <DESCRIPTION>End reading Hadoop MD Store</DESCRIPTION>
    <PARAMETERS/>
    <ARCS>
        <ARC to="failure"/>
    </ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraFieldHadoop">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>

