/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.message.Message;
import eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message.DnetMessageManager;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubmitDnetHadoopJobNode
extends SubmitHadoopJobNode
implements ProgressProvider,
ProgressJobNode {
    private static final Log log = LogFactory.getLog(SubmitDnetHadoopJobNode.class);
    @Autowired
    DnetMessageManager dnetMessageManager;
    private boolean ongoing = true;
    private int currentValue;
    private String wfId;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        this.wfId = token.getProcess().getEnv().getAttribute("system:processId");
        Runnable r = () -> {
            while (this.ongoing) {
                Message mess = this.dnetMessageManager.getOnGoingMessages(this.wfId);
                if (mess == null || mess.getBody() == null || !mess.getBody().containsKey("ongoing")) continue;
                try {
                    this.currentValue = Integer.parseInt((String)mess.getBody().get("ongoing"));
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    log.error((Object)"Error ono receiving messages ", e);
                }
            }
        };
        new Thread(r).start();
        super.prepareJob(job, token);
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, final NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void onFailed(BlackboardJob job) {
                SubmitDnetHadoopJobNode.this.ongoing = false;
                log.warn((Object)("Blackboard workflow node FAILED: " + job.getError()));
                token.getEnv().setAttribute("system:hasFailed", (Object)true);
                token.getEnv().setAttribute("system:error", job.getError());
                this.complete(job, "abort");
            }

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                SubmitDnetHadoopJobNode.this.ongoing = false;
                List<Message> reports = SubmitDnetHadoopJobNode.this.dnetMessageManager.getReport(SubmitDnetHadoopJobNode.this.wfId);
                if (reports == null) {
                    int numberOftries = 0;
                    try {
                        while (reports == null && numberOftries < 3) {
                            reports = SubmitDnetHadoopJobNode.this.dnetMessageManager.getReport(SubmitDnetHadoopJobNode.this.wfId);
                            Thread.sleep(3000 * numberOftries++);
                        }
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Error on waiting report", (Throwable)e);
                    }
                }
                if (reports == null) {
                    throw new RuntimeException("Unable to get report for WorklowId " + SubmitDnetHadoopJobNode.this.wfId);
                }
                reports.forEach(it -> it.getBody().forEach((arg_0, arg_1) -> ((Env)env).setAttribute(arg_0, arg_1)));
            }
        };
    }

    public int getTotalValue() {
        return 0;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public boolean isInaccurate() {
        return false;
    }

    public ProgressProvider getProgressProvider() {
        return this;
    }
}

