/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.annotation.Required;

public abstract class PrepareIISParamsV2
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareIISParamsV2.class);
    @Resource
    protected ConfigurationEnumerator configurationEnumerator;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String clusterName;
    private String clusterParam = "cluster";
    private String oozieWfAppPath;
    private String oozieWfAppPathParam = "oozie.wf.application.path";
    private String xqueryMdStoreService;
    private String mdStoreStoreLocationParam = "import_mdstore_service_location";
    private String xqueryObjectStoreService;
    private String objectStoreLocationParam = "import_content_object_store_location";
    private String xqueryIsLookupService;
    private String islookupLocationParam = "import_islookup_service_location";
    private String importProjectConceptsContextCSVParam = "import_project_concepts_context_ids_csv";
    private String importProjectConceptsContextCSV;
    private String xqueryDatasetStore;
    private String mdStoreDatasetParam = "import_dataset_mdstore_ids_csv";
    private String objectStoreBlacklistCSV = "";

    protected void prepare(NodeToken token) throws Exception {
        token.getEnv().setAttribute(this.getClusterParam(), this.getClusterName());
        token.getEnv().setAttribute(this.getMdStoreStoreLocationParam(), this.getServiceEndpoint(this.getXqueryMdStoreService()));
        token.getEnv().setAttribute(this.getObjectStoreLocationParam(), this.getServiceEndpoint(this.getXqueryObjectStoreService()));
        token.getEnv().setAttribute(this.getIslookupLocationParam(), this.getServiceEndpoint(this.getXqueryIsLookupService()));
        token.getEnv().setAttribute(this.getImportProjectConceptsContextCSVParam(), this.getImportProjectConceptsContextCSV());
        Configuration conf = this.configurationEnumerator.get(ClusterName.valueOf((String)this.getClusterName()));
        String nameNode = conf.get("fs.defaultFS");
        token.getEnv().setAttribute(this.getOozieWfAppPathParam(), this.getURI(nameNode, this.getOozieWfAppPath()));
        token.getEnv().setAttribute(this.getMdStoreDatasetParam(), this.asCSV(this.getProfileIds(this.getXqueryDatasetStore())));
    }

    protected String getServiceEndpoint(String xquery) throws MSROException {
        try {
            return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery));
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch service endpoint", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new MSROException("unable to find service endpoint, xquery: " + this.getXqueryMdStoreService(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MSROException("more than one services found, we assume to have only one available", (Throwable)e);
        }
    }

    protected String getProfileId(String xquery) throws MSROException {
        try {
            return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery));
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch profile id", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new MSROException("unable to find profile profile, xquery: " + xquery, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MSROException("more than one profile profiles was found, we assume to have only one available, xquery: " + xquery, (Throwable)e);
        }
    }

    protected List<String> getProfileIds(String xquery) throws MSROException {
        try {
            List ids = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
            if (ids.isEmpty()) {
                log.warn((Object)("couldn't find any profile, xquery: " + xquery));
            }
            return ids;
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch profile ids, x query: " + xquery, (Throwable)e);
        }
    }

    protected String getFilteredObjectStoreCSV(String xquery) throws MSROException {
        return this.asCSV(this.filter(this.getProfileIds(xquery), this.asList(this.getObjectStoreBlacklistCSV())));
    }

    protected List<String> filter(List<String> list, List<String> filter) {
        if (filter == null || filter.isEmpty()) {
            return list;
        }
        list.removeAll(filter);
        return list;
    }

    protected String asCSV(List<String> list) {
        return Joiner.on((String)",").skipNulls().join(list);
    }

    protected List<String> asList(String csv) {
        return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)csv));
    }

    private String getURI(String nameNode, String relative) {
        return nameNode + relative;
    }

    private String getZkQuorumCSV(Configuration conf, String zkPort) {
        return Joiner.on((String)(":" + zkPort + ",")).join(Splitter.on((String)",").omitEmptyStrings().split((CharSequence)conf.get("hbase.zookeeper.quorum")));
    }

    @Required
    public void setXqueryMdStoreService(String xqueryMdStoreService) {
        this.xqueryMdStoreService = xqueryMdStoreService;
    }

    public String getXqueryMdStoreService() {
        return this.xqueryMdStoreService;
    }

    public String getMdStoreStoreLocationParam() {
        return this.mdStoreStoreLocationParam;
    }

    public void setMdStoreStoreLocationParam(String mdStoreStoreLocationParam) {
        this.mdStoreStoreLocationParam = mdStoreStoreLocationParam;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterParam() {
        return this.clusterParam;
    }

    public void setClusterParam(String clusterParam) {
        this.clusterParam = clusterParam;
    }

    public String getOozieWfAppPathParam() {
        return this.oozieWfAppPathParam;
    }

    public void setOozieWfAppPathParam(String oozieWfAppPathParam) {
        this.oozieWfAppPathParam = oozieWfAppPathParam;
    }

    public String getOozieWfAppPath() {
        return this.oozieWfAppPath;
    }

    public void setOozieWfAppPath(String oozieWfAppPath) {
        this.oozieWfAppPath = oozieWfAppPath;
    }

    @Required
    public String getXqueryDatasetStore() {
        return this.xqueryDatasetStore;
    }

    public void setXqueryDatasetStore(String xqueryDatasetStore) {
        this.xqueryDatasetStore = xqueryDatasetStore;
    }

    public String getMdStoreDatasetParam() {
        return this.mdStoreDatasetParam;
    }

    public void setMdStoreDatasetParam(String mdStoreDatasetParam) {
        this.mdStoreDatasetParam = mdStoreDatasetParam;
    }

    public String getXqueryObjectStoreService() {
        return this.xqueryObjectStoreService;
    }

    @Required
    public void setXqueryObjectStoreService(String xqueryObjectStoreService) {
        this.xqueryObjectStoreService = xqueryObjectStoreService;
    }

    public String getObjectStoreLocationParam() {
        return this.objectStoreLocationParam;
    }

    public void setObjectStoreLocationParam(String objectStoreLocationParam) {
        this.objectStoreLocationParam = objectStoreLocationParam;
    }

    public String getObjectStoreBlacklistCSV() {
        return this.objectStoreBlacklistCSV;
    }

    public void setObjectStoreBlacklistCSV(String objectStoreBlacklistCSV) {
        this.objectStoreBlacklistCSV = objectStoreBlacklistCSV;
    }

    public String getXqueryIsLookupService() {
        return this.xqueryIsLookupService;
    }

    @Required
    public void setXqueryIsLookupService(String xqueryIsLookupService) {
        this.xqueryIsLookupService = xqueryIsLookupService;
    }

    public String getIslookupLocationParam() {
        return this.islookupLocationParam;
    }

    public void setIslookupLocationParam(String islookupLocationParam) {
        this.islookupLocationParam = islookupLocationParam;
    }

    public String getImportProjectConceptsContextCSVParam() {
        return this.importProjectConceptsContextCSVParam;
    }

    public void setImportProjectConceptsContextCSVParam(String importProjectConceptsContextCSVParam) {
        this.importProjectConceptsContextCSVParam = importProjectConceptsContextCSVParam;
    }

    public String getImportProjectConceptsContextCSV() {
        return this.importProjectConceptsContextCSV;
    }

    public void setImportProjectConceptsContextCSV(String importProjectConceptsContextCSV) {
        this.importProjectConceptsContextCSV = importProjectConceptsContextCSV;
    }
}

