package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import java.util.List;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SwitchIndexJobNode performs index switch.
 *
 * @author claudio
 * @see eu.dnetlib.msro.openaireplus.workflows.nodes.index.SwitchSearchServiceJobNode
 * @see eu.dnetlib.msro.openaireplus.workflows.nodes.index.SwitchIndexesJobNode
 * @deprecated
 */
@Deprecated
public class SwitchIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(SwitchIndexJobNode.class);
	private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";

	private String inputIndexIdParam;

	private String outputIndexIdParam;

	private String xqueryForServiceIdParam;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		final String xquery = token.getEnv().getAttribute(getXqueryForServiceIdParam());
		List<String> searchServiceIds;
		try {
			searchServiceIds = getServiceLocator().getService(ISLookUpService.class).quickSearchProfile(xquery);
			if (searchServiceIds.size() > 1) throw new RuntimeException("Too many SearchService ids found using query: " + xquery);
			if (searchServiceIds.size() < 1) throw new RuntimeException("SearchService id not found using query: " + xquery);
			return searchServiceIds.get(0);
		} catch (ISLookUpException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(BB_ACTION_SWITCH_INDEX);
		String indexId = token.getEnv().getAttribute(getInputIndexIdParam());

		checkParam(getInputIndexIdParam(), "output indexId param is missing");
		checkParam(indexId, "indexId is required to perform switch");
		log.info("Switching " + obtainServiceId(token) + " to index " + indexId);
		job.getParameters().put(getOutputIndexIdParam(), indexId);
	}

	private void checkParam(final String param, final String msg) throws MSROException {
		if (StringUtils.isBlank(param)) throw new MSROException(msg);
	}

	public String getInputIndexIdParam() {
		return inputIndexIdParam;
	}

	public void setInputIndexIdParam(final String inputIndexIdParam) {
		this.inputIndexIdParam = inputIndexIdParam;
	}

	public String getOutputIndexIdParam() {
		return outputIndexIdParam;
	}

	public void setOutputIndexIdParam(final String outputIndexIdParam) {
		this.outputIndexIdParam = outputIndexIdParam;
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
