/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.collector.worker.model.ApiDescriptor;
import eu.dnetlib.dhp.model.mdstore.Provenance;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareEnvCollectHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareEnvCollectHadoopJobNode.class);
    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;
    private String hdfsBasePath;

    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getEnv().getAttribute("dataprovider:id");
        String apiId = token.getEnv().getAttribute("dataprovider:interface");
        String mdId = token.getEnv().getAttribute("mdId");
        String versionId = token.getEnv().getAttribute("versionId");
        Optional<ApiDescriptor> opt = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(apiId)).map(a -> {
            ApiDescriptor res = new ApiDescriptor();
            res.setBaseUrl(a.getBaseurl());
            res.setId(a.getId());
            res.setProtocol(a.getProtocol());
            res.getParams().put("metadata_identifier_path", a.getMetadataIdentifierPath());
            res.getParams().putAll(a.getApiParams().stream().map(o -> o).collect(Collectors.toMap(ApiParam::getParam, ApiParam::getValue)));
            return res;
        }).findFirst();
        if (opt.isPresent()) {
            ApiDescriptor api = opt.get();
            String hdfsPath = String.format("%s/%s/%s/store", this.hdfsBasePath, mdId, versionId);
            String seqFilePath = String.format("%s/%s/%s/seqFile", this.hdfsBasePath, mdId, versionId);
            token.getEnv().setAttribute("apiDescription", new Gson().toJson((Object)api));
            token.getEnv().setAttribute("mdStorePath", hdfsPath);
            token.getEnv().setAttribute("sequenceFilePath", seqFilePath);
            Provenance provenance = new Provenance();
            provenance.setDatasourceId(dsId);
            Datasource ds = this.dsManager.getDs(dsId);
            provenance.setDatasourceName(ds.getOfficialname());
            provenance.setNsPrefix(ds.getNamespaceprefix());
            token.getEnv().setAttribute("dataSourceInfo", new Gson().toJson((Object)provenance));
            token.getEnv().setAttribute("timestamp", "" + System.currentTimeMillis());
            token.getEnv().setAttribute("identifierPath", (String)api.getParams().get("metadata_identifier_path"));
            token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
            token.getEnv().setAttribute("dataprovider:interface:baseUrl", api.getBaseUrl());
            token.getEnv().setAttribute("dataprovider:protocol", api.getProtocol());
            Map params = api.getParams();
            if (params != null) {
                for (Map.Entry e : params.entrySet()) {
                    token.getEnv().setAttribute("dataprovider:" + (String)e.getKey(), (String)e.getValue());
                }
            }
            return Arc.DEFAULT_ARC;
        }
        return "abort";
    }

    public String getHdfsBasePath() {
        return this.hdfsBasePath;
    }

    public void setHdfsBasePath(String hdfsBasePath) {
        this.hdfsBasePath = hdfsBasePath;
    }
}

