/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class FixRepoMdstoreSizesJobNode
extends SimpleJobNode
implements ProgressJobNode {
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Resource(name="mongodbMDStoreDao")
    private MDStoreDao mdstoreDao;
    @Autowired
    private ObjectStoreDao objectStoreDao;
    private final DateUtils dateUtils = new DateUtils();
    private int current = 0;
    private int total = 0;
    private ISRegistryService registry;
    private ISLookUpService lookup;
    private final Map<String, String> openaireIds = new HashMap<String, String>();
    private boolean alwaysUpdate = false;
    private static final Log log = LogFactory.getLog(FixRepoMdstoreSizesJobNode.class);

    public void init(int total) {
        this.current = 0;
        this.total = total;
        this.lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        this.registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        try {
            this.openaireIds.putAll(this.lookup.quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//DATASOURCE_ORIGINAL_ID, ' @@@ ', $x//RESOURCE_IDENTIFIER/@value)").stream().collect(Collectors.toMap(s -> StringUtils.substringBefore((String)s, (String)"@@@").trim(), s -> StringUtils.substringAfter((String)s, (String)"@@@").trim())));
        }
        catch (ISLookUpException e) {
            e.printStackTrace();
        }
    }

    protected String execute(NodeToken token) throws Exception {
        Set list = this.dsManager.listManagedDatasourceIds();
        this.init(list.size());
        for (String dsId : list) {
            log.info((Object)("Processing ds: " + dsId));
            ++this.current;
            try {
                for (Api api : this.dsManager.getApis(dsId)) {
                    this.verifyApi(dsId, (Api<ApiParam>)api);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error processing ds: " + dsId), e);
                token.getEnv().setAttribute("mainlog:" + dsId, e.getMessage());
            }
        }
        return Arc.DEFAULT_ARC;
    }

    private void verifyApi(String dsId, Api<ApiParam> api) throws DsmException, ISRegistryException, IOException, ISLookUpException, MDStoreServiceException, ObjectStoreServiceException {
        int size;
        int actualSize;
        String mdId;
        for (Document doc : this.listCollectionMdStores(dsId, api.getId())) {
            mdId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            actualSize = NumberUtils.toInt((String)doc.valueOf("//NUMBER_OF_RECORDS"), (int)0);
            size = this.mdstoreDao.getMDStore(mdId).getSize();
            if (!this.alwaysUpdate && size == actualSize) continue;
            log.info((Object)("  -- Updating size of api " + api.getId() + ", new value = " + size));
            this.updateMdStoreProfile(mdId, doc, size);
            this.dsManager.setLastCollectionInfo(dsId, api.getId(), mdId, Integer.valueOf(size), this.calculateLastDate(doc));
        }
        for (Document doc : this.listTransformationMdStores(dsId, api.getId())) {
            mdId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            actualSize = NumberUtils.toInt((String)doc.valueOf("//NUMBER_OF_RECORDS"), (int)0);
            size = this.mdstoreDao.getMDStore(mdId).getSize();
            if (!this.alwaysUpdate && size == actualSize) continue;
            this.updateMdStoreProfile(mdId, doc, size);
            this.dsManager.setLastAggregationInfo(dsId, api.getId(), mdId, Integer.valueOf(size), this.calculateLastDate(doc));
        }
        for (Document doc : this.listDownloadObjectStores(dsId, api.getId())) {
            String objId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            actualSize = NumberUtils.toInt((String)doc.valueOf("//STORE_SIZE"), (int)0);
            size = this.objectStoreDao.getObjectStore(objId).getSize();
            if (!this.alwaysUpdate && size == actualSize) continue;
            this.updateObjStoreProfile(objId, doc, size);
            this.dsManager.setLastDownloadInfo(dsId, api.getId(), objId, Integer.valueOf(size), this.calculateLastDate(doc));
        }
    }

    private Date calculateLastDate(Document doc) {
        String dateS = doc.valueOf("//LAST_STORAGE_DATE");
        Date date = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateS}) ? this.dateUtils.parse(dateS) : new Date();
        return date;
    }

    private List<Document> listCollectionMdStores(String dsId, String apiId) throws ISLookUpException, IOException {
        return this.executeXquery("listCollectionMdStores.xquery.st", dsId, apiId);
    }

    private List<Document> listTransformationMdStores(String dsId, String apiId) throws ISLookUpException, IOException {
        return this.executeXquery("listTransformationMdStores.xquery.st", dsId, apiId);
    }

    private List<Document> listDownloadObjectStores(String dsId, String apiId) throws ISLookUpException, IOException {
        return this.executeXquery("listDownloadObjectStores.xquery.st", dsId, apiId);
    }

    private List<Document> executeXquery(String template, String dsId, String apiId) throws ISLookUpException, IOException {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(template)));
        st.setAttribute("dsId", (Object)this.openaireIds.get(dsId));
        st.setAttribute("apiId", (Object)apiId);
        SAXReader reader = new SAXReader();
        return this.lookup.quickSearchProfile(st.toString()).stream().map(s -> {
            try {
                return reader.read((Reader)new StringReader((String)s));
            }
            catch (DocumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void updateMdStoreProfile(String mdId, Document doc, int size) throws ISRegistryException {
        doc.selectSingleNode("//NUMBER_OF_RECORDS").setText(Integer.toString(size));
        this.registry.updateProfile(mdId, doc.asXML(), "MDStoreDSResourceType");
    }

    private void updateObjStoreProfile(String objId, Document doc, int size) throws ISRegistryException {
        doc.selectSingleNode("//COUNT_STORE").setText(Integer.toString(size));
        doc.selectSingleNode("//STORE_SIZE").setText(Integer.toString(size));
        this.registry.updateProfile(objId, doc.asXML(), "ObjectStoreDSResourceType");
    }

    public boolean isAlwaysUpdate() {
        return this.alwaysUpdate;
    }

    public void setAlwaysUpdate(boolean alwaysUpdate) {
        this.alwaysUpdate = alwaysUpdate;
    }

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public int getTotalValue() {
                return FixRepoMdstoreSizesJobNode.this.total;
            }

            public int getCurrentValue() {
                return FixRepoMdstoreSizesJobNode.this.current;
            }

            public boolean isInaccurate() {
                return false;
            }
        };
    }
}

