package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class FindInvalidWorkflowsJobNode extends SimpleJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private static final Log log = LogFactory.getLog(FindInvalidWorkflowsJobNode.class);

	private boolean deleteInvalidProfiles = false;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final ISLookUpService lookup = serviceLocator.getService(ISLookUpService.class);
		final ISRegistryService registry = serviceLocator.getService(ISRegistryService.class);

		final String q1 =
				"for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')//WORKFLOW/@id|//CONFIGURATION/@destroyWorkflow return $x/string()";

		final String q2 = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";

		final Set<String> valids = new HashSet<>(lookup.quickSearchProfile(q1));

		int count = 0;
		int countInvalids = 0;
		int countDeleted = 0;
		for (final String wfId : lookup.quickSearchProfile(q2)) {
			count++;
			if (!valids.contains(wfId)) {
				log.warn("Invalid wf: " + wfId);
				countInvalids++;
				if (deleteInvalidProfiles) {
					registry.deleteProfile(wfId);
					log.info(" -- Deleted");
					countDeleted++;
				}

			}
		}

		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", count);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "invalid", countInvalids);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "deleted", countDeleted);

		return Arc.DEFAULT_ARC;
	}

	public boolean isDeleteInvalidProfiles() {
		return deleteInvalidProfiles;
	}

	public void setDeleteInvalidProfiles(final boolean deleteInvalidProfiles) {
		this.deleteInvalidProfiles = deleteInvalidProfiles;
	}

}
