 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Obtain data source params</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_STORE_VERSION"/>
	</ARCS>
</NODE>
<NODE name="PREPARE_STORE_VERSION" type="PrepareMDStoreVersion">
	<DESCRIPTION>Prepare a new MdStore Version</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
        <ARC to="PREPARE_ENV_COLLECTION"/>
    </ARCS>
</NODE>
<NODE name="PREPARE_ENV_COLLECTION" type="PrepareEnvCollectHadoopJobNode">
    <DESCRIPTION>Put in the environment all the variable needed to the collection oozie job </DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="user" name="hdfsBasePath" required="true" type="string"></PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="COLLECT_HADOOP"/>
    </ARCS>
</NODE>
<NODE name="COLLECT_HADOOP" type="SubmitDnetHadoopJobNode">
    <DESCRIPTION>Start the Hadoop Job</DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="system" name="hadoopJob" required="true" type="string">dnetHadoopCollection</PARAM>
        <PARAM managedBy="user" name="cluster" required="true" type="string">DHP</PARAM>
        <PARAM managedBy="system" name="envParams" required="true" type="string">
            {
                "apiDescription":"apiDescription",
                "mdStorePath":"mdStorePath",
                "sequenceFilePath":"sequenceFilePath",
                "dataSourceInfo":"dataSourceInfo"  ,
                "timestamp":"timestamp",
                "identifierPath":"identifierPath",
                "workflowId":"workflowId"
            }
        </PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="COMMIT_VERSION"/>
        <ARC name="abort" to="ABORT_VERSION"/>
    </ARCS>
</NODE>

<NODE name="COMMIT_VERSION" type="CommitMDStoreVersion">
	<DESCRIPTION>Commit the mdstore version</DESCRIPTION>
	<PARAMETERS/>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="ABORT_VERSION" type="AbortMDStoreVersion">
	<DESCRIPTION>Abort the mdstore version</DESCRIPTION>
	<PARAMETERS/>
	<ARCS>
		<ARC to="failure"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraFieldHadoop">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_collection_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_collection_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_collection_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
