/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByEntry;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class PatchHostedBy
implements UnaryFunction<String, String> {
    private Map<String, HostedByEntry> setSpecHostedByMap;
    private HostedByCounters counters;
    private String xpath;
    private final SAXReader reader = new SAXReader();
    private static final Log log = LogFactory.getLog(PatchHostedBy.class);

    public PatchHostedBy(Map<String, HostedByEntry> setSpecHostedByMap, String xpath, HostedByCounters counters) {
        this.setSpecHostedByMap = setSpecHostedByMap;
        this.xpath = xpath;
        this.counters = counters;
        if (log.isDebugEnabled()) {
            log.debug((Object)"****************************************");
            log.debug((Object)"SetSpec/hostedBy map:");
            for (Map.Entry<String, HostedByEntry> e : setSpecHostedByMap.entrySet()) {
                log.debug((Object)("   " + e.getKey() + " -> " + e.getValue()));
            }
            log.debug((Object)"****************************************");
        }
    }

    public String evaluate(String record) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(record));
            Element node = (Element)doc.selectSingleNode("//*[local-name()='metadata']/*[local-name()='hostedBy']");
            if (node != null) {
                HostedByEntry ds = this.findHostedBy(doc);
                if (ds != null) {
                    node.addAttribute("id", ds.getId());
                    node.addAttribute("name", ds.getName());
                    this.counters.increaseCounter(ds.getId());
                }
                return doc.asXML();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)" -- Missing hostedBy --");
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error adding hosted by to " + record));
        }
        return record;
    }

    private HostedByEntry findHostedBy(Document doc) {
        for (Object o : doc.selectNodes(this.xpath)) {
            String set = ((Node)o).getText().trim();
            if (this.setSpecHostedByMap.containsKey(set)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(set + " -> " + this.setSpecHostedByMap.get(set)));
                }
                return this.setSpecHostedByMap.get(set);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(set + " -> UNKNOWN REPO"));
        }
        return null;
    }
}

