package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CommitMDStoreVersionJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(CommitMDStoreVersionJobNode.class);

    /* Spring managed params */
    private String mdStoreManagerUrl;

    @Override
    protected String execute(final NodeToken token) throws Exception {
        final String url = getMdStoreManagerUrl() + "/version/{versionId}/commit/{size}";

        final Map<String, Object> params = new HashMap<>();
        params.put("versionId", token.getEnv().getAttribute("versionId"));
        params.put("size", token.getEnv().getAttribute("mdStoreSize"));

        final URI uri = UriComponentsBuilder.fromUriString(url)
                .buildAndExpand(params)
                .toUri();

        final RestTemplate restTemplate = new RestTemplate();
        restTemplate.getForObject(uri, Void.class);

        log.info("mdstore version committed ");
        return Arc.DEFAULT_ARC;
    }

    public String getMdStoreManagerUrl() {
        return mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }
}

