/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.openaire.directindex.api.RecentResultsQueue;
import eu.dnetlib.openaire.directindex.utils.OafToIndexRecordFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class FeedMissingClaimsJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(FeedMissingClaimsJobNode.class);
    public static final int BATCH_SIZE = 1000;
    private RecentResultsQueue queue;
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;

    protected String execute(NodeToken nodeToken) throws Exception {
        String format = nodeToken.getEnv().hasAttribute("format") ? nodeToken.getEnv().getAttribute("format") : nodeToken.getFullEnv().getAttribute("format");
        String coll = format + "-index-openaire";
        String indexDsId = nodeToken.getEnv().getAttribute("index_id");
        String baseUrl = this.calculateIndexBaseUrl();
        CloudIndexClient idxClient = null;
        try {
            ArrayList<SolrInputDocument> toFeed = new ArrayList<SolrInputDocument>();
            ArrayList<String> toDeleteFromCache = new ArrayList<String>();
            SAXReader reader = new SAXReader();
            ApplyXslt xslt = this.oafToIndexRecordFactory.newTransformer(format);
            idxClient = CloudIndexClientFactory.newIndexClient((String)baseUrl, (String)coll, (boolean)false);
            log.info((Object)("Starting to feed claims in index collection " + coll));
            int count = 1;
            for (String record : this.queue) {
                String id = reader.read((Reader)new StringReader(record)).valueOf("//*[local-name() = 'objIdentifier']");
                ++count;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing record " + count));
                }
                if (idxClient.isRecordIndexed(id)) {
                    toDeleteFromCache.add(id);
                } else {
                    toFeed.add(idxClient.prepareSolrDocument(record, indexDsId, (UnaryFunction)xslt));
                }
                if (count % 1000 != 0) continue;
                this.processLists(idxClient, toFeed, toDeleteFromCache);
            }
            if (!toFeed.isEmpty() || !toDeleteFromCache.isEmpty()) {
                this.processLists(idxClient, toFeed, toDeleteFromCache);
            }
            log.info((Object)String.format("Finished feeding of claims in index collection %s, total: %d", coll, count));
        }
        catch (Throwable e) {
            log.error((Object)"Error feeding missing claims", e);
            throw new MSROException("Error feeding missing claims: " + e.getMessage(), e);
        }
        finally {
            if (idxClient != null) {
                idxClient.close();
            }
            log.info((Object)"Closed Solr index client");
        }
        log.info((Object)"Now proceeding to Arc.DEFAULT_ARC");
        return Arc.DEFAULT_ARC;
    }

    private void processLists(CloudIndexClient idxClient, List<SolrInputDocument> toFeed, List<String> toDeleteFromCache) throws CloudIndexClientException {
        idxClient.feed(toFeed, null);
        this.queue.remove(toDeleteFromCache);
        log.info((Object)String.format("%d claims fed and cache cleaned of %d records", toFeed.size(), toDeleteFromCache.size()));
        toFeed.clear();
        toDeleteFromCache.clear();
        log.info((Object)"Cleaned temporary lists");
    }

    public RecentResultsQueue getQueue() {
        return this.queue;
    }

    @Required
    public void setQueue(RecentResultsQueue queue) {
        this.queue = queue;
    }

    public OafToIndexRecordFactory getOafToIndexRecordFactory() {
        return this.oafToIndexRecordFactory;
    }

    @Required
    public void setOafToIndexRecordFactory(OafToIndexRecordFactory oafToIndexRecordFactory) {
        this.oafToIndexRecordFactory = oafToIndexRecordFactory;
    }

    private String calculateIndexBaseUrl() throws Exception {
        String query = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }
}

