package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import com.google.gson.Gson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.manager.common.model.MDStoreWithInfo;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class CreateMDStoreHadoopJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(CreateMDStoreHadoopJobNode.class);

    /* Workflow params */
    private String format;
    private String layout;
    private String interpretation;
    private String outputPrefix = "mdstore";

    /* Spring managed params */
    private String mdStoreManagerUrl;

    @Override
    protected String execute(final NodeToken token) throws Exception {
        final String url = getMdStoreManagerUrl() + "/new/{format}/{layout}/{interpretation}";

        final Map<String, Object> params = new HashMap<>();
        params.put("format", getFormat());
        params.put("layout", getLayout());
        params.put("interpretation", getInterpretation());

        final URI uri = UriComponentsBuilder.fromUriString(url)
                .queryParam("dsName", token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_NAME))
                .queryParam("dsId", token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID))
                .queryParam("apiId", token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE))
                .buildAndExpand(params)
                .toUri();

        log.info("create mdstore request: " + uri.toString());

        final RestTemplate restTemplate = new RestTemplate();
        final MDStoreWithInfo result = restTemplate.getForObject(uri, MDStoreWithInfo.class);

        log.info("created mdstore: " + new Gson().toJson(result));

        token.getEnv().setAttribute(getOutputPrefix() + "format", format);
        token.getEnv().setAttribute(getOutputPrefix() + "layout", layout);
        token.getEnv().setAttribute(getOutputPrefix() + "interpretation", interpretation);
        token.getEnv().setAttribute(getOutputPrefix() + "id", result.getId());

        return Arc.DEFAULT_ARC;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(final String format) {
        this.format = format;
    }

    public String getLayout() {
        return layout;
    }

    public void setLayout(final String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return interpretation;
    }

    public void setInterpretation(final String interpretation) {
        this.interpretation = interpretation;
    }

    public String getOutputPrefix() {
        return outputPrefix;
    }

    public void setOutputPrefix(final String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public String getMdStoreManagerUrl() {
        return mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }

}
