<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Obtain data source params</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_ENV_COLLECTION"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_ENV_COLLECTION" type="PrepareEnvCollectHadoopJobNode">
    <DESCRIPTION>Set in the environment all the variable needed to the collection oozie job</DESCRIPTION>
    <PARAMETERS>
        <PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
        <PARAM required="true" type="string" name="collectionMode" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])"></PARAM>
        <PARAM required="true" type="string" name="metadataEncoding" managedBy="user">XML</PARAM>
        <PARAM managedBy="user" name="fromDateOverride" required="false" type="string"/>
        <PARAM managedBy="user" name="maxNumberOfRetry" required="false" type="int">5</PARAM>
        <PARAM managedBy="user" name="requestDelay" required="false" type="int">0</PARAM>
        <PARAM managedBy="user" name="retryDelay" required="false" type="int">60</PARAM>
        <PARAM managedBy="user" name="connectTimeOut" required="false" type="int">30</PARAM>
        <PARAM managedBy="user" name="readTimeOut" required="false" type="int">60</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="COLLECT_HADOOP"/>
    </ARCS>
</NODE>

<NODE name="COLLECT_HADOOP" type="SubmitDnetHadoopJobNode">
    <DESCRIPTION>Start the Hadoop Job</DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="system" name="hadoopJob" required="true" type="string">executeOozieJob</PARAM>
        <PARAM managedBy="user" name="cluster" required="true" type="string">DHP</PARAM>
        <PARAM managedBy="system" name="envParams" required="true" type="string">
            {
                "apiDescription":"apiDescription",
                "dataSourceInfo":"dataSourceInfo",
                "identifierPath":"identifierPath",
                "metadataEncoding":"metadataEncoding",
                "timestamp":"timestamp",
                "workflowId":"workflowId",
                "mdStoreID":"mdId",
                "collectionMode":"collectionMode",
                "maxNumberOfRetry":"maxNumberOfRetry",
                "requestDelay":"requestDelay",
                "retryDelay":"retryDelay",
                "connectTimeOut":"connectTimeOut",
                "readTimeOut":"readTimeOut",
                "dnetMessageManagerURL":"dnetMessageManagerURL",
                "oozie.wf.application.path":"oozieWfPath"
            }
        </PARAM>
        <PARAM managedBy="system" name="params" required="true" type="string">
            {
                "collection_java_xmx" : "-Xmx300m"
            }
        </PARAM>
        <PARAM managedBy="system" name="oozieReportActionsCsv" required="true" type="string">BeginRead,StartTransaction,CollectionWorker</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="UPDATE_INFO"/>
    </ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraFieldHadoop">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_collection_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_collection_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_collection_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
