/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.manager.common.model.MDStoreWithInfo;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CreateMDStoreHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CreateMDStoreHadoopJobNode.class);
    private String format;
    private String layout;
    private String interpretation;
    private String outputPrefix = "mdstore";
    private String mdStoreManagerUrl;

    protected String execute(NodeToken token) throws Exception {
        String url = this.getMdStoreManagerUrl() + "/new/{format}/{layout}/{interpretation}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", this.getFormat());
        params.put("layout", this.getLayout());
        params.put("interpretation", this.getInterpretation());
        URI uri = UriComponentsBuilder.fromUriString((String)url).queryParam("dsName", new Object[]{token.getFullEnv().getAttribute("dataprovider:name")}).queryParam("dsId", new Object[]{token.getFullEnv().getAttribute("dataprovider:originalid")}).queryParam("apiId", new Object[]{token.getFullEnv().getAttribute("dataprovider:interface")}).buildAndExpand(params).toUri();
        log.info((Object)("create mdstore request: " + uri.toString()));
        RestTemplate restTemplate = new RestTemplate();
        MDStoreWithInfo result = (MDStoreWithInfo)restTemplate.getForObject(uri, MDStoreWithInfo.class);
        log.info((Object)("created mdstore: " + new Gson().toJson((Object)result)));
        token.getEnv().setAttribute(this.getOutputPrefix() + "format", this.format);
        token.getEnv().setAttribute(this.getOutputPrefix() + "layout", this.layout);
        token.getEnv().setAttribute(this.getOutputPrefix() + "interpretation", this.interpretation);
        token.getEnv().setAttribute(this.getOutputPrefix() + "id", result.getId());
        return Arc.DEFAULT_ARC;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public String getMdStoreManagerUrl() {
        return this.mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }
}

