/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.manager.common.model.MDStoreWithInfo;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;

public class CreateMDStoreHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CreateMDStoreHadoopJobNode.class);
    public static final String MDSTORE_CREATE_URL_AND_PARAMS = "/new/{format}/{layout}/{interpretation}?dsName={dsName}&dsId={dsid}&apiId={apiId}";
    private String format;
    private String layout;
    private String interpretation;
    private String outputPrefix = "mdstore";
    private String mdStoreManagerUrl;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        String openAireDataSourceId = token.getFullEnv().getAttribute("dataprovider:id");
        String urlTemplate = this.getMdStoreManagerUrl() + MDSTORE_CREATE_URL_AND_PARAMS;
        RestTemplate restTemplate = new RestTemplate();
        MDStoreWithInfo result = (MDStoreWithInfo)restTemplate.getForObject(urlTemplate, MDStoreWithInfo.class, new Object[]{this.getFormat(), this.getLayout(), this.getInterpretation(), token.getFullEnv().getAttribute("dataprovider:name"), openAireDataSourceId, token.getFullEnv().getAttribute("dataprovider:interface")});
        log.info((Object)("created mdstore: " + new Gson().toJson((Object)result)));
        token.getEnv().setAttribute(this.getOutputPrefix() + "format", this.format);
        token.getEnv().setAttribute(this.getOutputPrefix() + "layout", this.layout);
        token.getEnv().setAttribute(this.getOutputPrefix() + "interpretation", this.interpretation);
        token.getEnv().setAttribute(this.getOutputPrefix() + "id", result.getId());
        return Arc.DEFAULT_ARC;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public String getMdStoreManagerUrl() {
        return this.mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }
}

