package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.stream.Collectors;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class UpdateVocabularyEntriesJobNode extends BlackboardJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private IterableResultSetFactory resultSetFactory;

	private Resource xquery;

	private String xsltClasspath;

	private String db;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(DatabaseService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {

		final ApplyXslt t = new ApplyXslt(new ClassPathResource(xsltClasspath));

		final W3CEndpointReference epr =
				resultSetFactory.createIterableResultSet(
						serviceLocator.getService(ISLookUpService.class).quickSearchProfile(IOUtils.toString(getXquery().getInputStream()))
								.stream().map(t::evaluate).collect(Collectors.toList()));

		job.setAction("IMPORT");
		job.getParameters().put("db", db);
		job.getParameters().put("epr", epr.toString());
	}

	public Resource getXquery() {
		return xquery;
	}

	@Required
	public void setXquery(final Resource xquery) {
		this.xquery = xquery;
	}

	public String getXsltClasspath() {
		return xsltClasspath;
	}

	public void setXsltClasspath(final String xsltClasspath) {
		this.xsltClasspath = xsltClasspath;
	}

	public String getDb() {
		return db;
	}

	public void setDb(final String db) {
		this.db = db;
	}

}
