/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.BuildH2020FETTaxonomy;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateFETH2020ContextJobNode
extends SimpleJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(GenerateFETH2020ContextJobNode.class);
    private String eprParam;
    private ResultsetProgressProvider progressProvider;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    protected String execute(NodeToken token) throws Exception {
        String epr = token.getEnv().getAttribute(this.eprParam);
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        IterableResultSetClient iter = this.resultSetClientFactory.getClient(this.progressProvider.getEpr());
        BuildH2020FETTaxonomy builder = new BuildH2020FETTaxonomy();
        builder.setIterator(iter.iterator());
        String taxonomy = builder.parseProjects();
        String xquery = "for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') where $x//CONFIGURATION/context[@id='fet-h2020'] return $x//RESOURCE_IDENTIFIER/@value/string()";
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') where $x//CONFIGURATION/context[@id='fet-h2020'] return $x//RESOURCE_IDENTIFIER/@value/string()");
        if (list.isEmpty()) {
            this.registerProfile(taxonomy);
        } else {
            this.deleteProfile((String)list.get(0));
            this.registerProfile(taxonomy);
        }
        return Arc.DEFAULT_ARC;
    }

    private void registerProfile(String profile) throws ISRegistryException {
        log.info((Object)"registering fet-h2020 profile");
        ISRegistryService is = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        String id = is.registerProfile(profile);
        log.info((Object)("Generating profile with id " + id));
    }

    private void deleteProfile(String profId) throws ISRegistryException {
        log.info((Object)("deleting fet-h2020 profile with id " + profId));
        ISRegistryService is = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        is.deleteProfile(profId);
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public void setProgressProvider(ResultsetProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

