-- https://support.openaire.eu/issues/6897 defined the new table for EOSC fields for dat sources
--CREATE TABLE dsm_datasources_eosc(
--    id               varchar(255) references dsm_datasources(id),
--    jurisdiction     text,
--    thematic         boolean,
--    knowledge_graph  boolean,
--    content_policies text[],
--    _dnet_resource_identifier_ varchar(2048) default ((('temp_'::text || md5((clock_timestamp())::text)) || '_'::text) || md5((random())::text))
--);

-- all institutional repositories have jurisdiction = 'Institutional' (5419 on dev)

INSERT INTO dsm_datasources_eosc(id, jurisdiction, _dnet_resource_identifier_)
SELECT id, 'Institutional', _dnet_resource_identifier_
FROM dsm_datasources
WHERE typology = 'pubsrepository::institutional';

-- scholarcomminfra have global jurisdiction (3 on dev)

INSERT INTO dsm_datasources_eosc(id, jurisdiction, _dnet_resource_identifier_)
SELECT id, 'Global', _dnet_resource_identifier_
FROM dsm_datasources
WHERE typology = 'scholarcomminfra' or typology='infospace';

-- thematic repositories are thematic (379 on dev)
INSERT INTO dsm_datasources_eosc(id, thematic, _dnet_resource_identifier_)
SELECT id, true, _dnet_resource_identifier_
FROM dsm_datasources
WHERE typology = 'pubsrepository::thematic';

-- journals, publishers and aggregators of journals have content_policies = ['Journal articles'] (16569 on dev)
INSERT INTO dsm_datasources_eosc(id, content_policies, _dnet_resource_identifier_)
SELECT id, ARRAY ['Journal articles'], _dnet_resource_identifier_
FROM dsm_datasources
WHERE typology = 'aggregator::pubsrepository::journals' or typology='pubsrepository::journal';

-- Now for the specific, well-known data sources we should fix the typology (when needed) and include the new fields
-- note that ids are from beta (in the hope that they are the same in prod)

-- Crossref is an entity registry (of products) with global jurisdiction
UPDATE dsm_datasources SET typology='entityregistry::products' WHERE id='openaire____::crossref';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::crossref', 'openaire____::crossref', 'Global');

-- Datacite is an entity registry (of products) with global jurisdiction
UPDATE dsm_datasources SET typology='entityregistry::products' WHERE id='openaire____::datacite';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::datacite', 'openaire____::datacite', 'Global');

-- ORCID is an entity registry (of persons) with global jurisdiction
UPDATE dsm_datasources SET typology='entityregistry::researchers' WHERE id='openaire____::orcid';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::orcid', 'openaire____::orcid', 'Global');

-- ROR is an entity registry (of orgs) with global jurisdicition
UPDATE dsm_datasources SET typology='entityregistry::organizations' WHERE id='openaire____::ROR';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::ROR', 'openaire____::ROR', 'Global');

-- Grid.ac is an entity registry (of orgs) with global jurisdicition
UPDATE dsm_datasources SET typology='entityregistry::organizations' WHERE id='openaire____::grid';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::grid', 'openaire____::grid', 'Global');

-- re3data is an entity registry (of data sources) with global jurisdiction
UPDATE dsm_datasources SET typology='entityregistry::repositories' WHERE id='openaire____::re3data';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::re3data', 'openaire____::re3data', 'Global');


-- opendoar is an entity registry (of data sources) with global jurisdiction
UPDATE dsm_datasources SET typology='entityregistry::repositories' WHERE id='openaire____::opendoar';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::opendoar', 'openaire____::opendoar', 'Global');

-- Unpaywall is an aggregator with global jurisdiction
UPDATE dsm_datasources SET typology='aggregator::pubsrepository::unknown' WHERE id='openaire____::unpaywall';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::unpaywall', 'openaire____::unpaywall', 'Global');

-- MAG is an aggregator with global jurisdiction and knowledge graph = true
UPDATE dsm_datasources SET typology='aggregator::pubsrepository::unknown' WHERE id='openaire____::microsoft';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction, knowledge_graph)
VALUES('openaire____::microsoft', 'openaire____::microsoft', 'Global', true);

-- OpenAIRE is an aggregator with global jurisdiction and knowledge graph = true
--UPDATE dsm_datasources SET typology='aggregator' WHERE id='infrastruct_::openaire';
UPDATE dsm_datasources_eosc SET knowledge_graph = true WHERE _dnet_resource_identifier_ = 'infrastruct_::openaire';

-- ScholeXplorer is an aggregator with global jurisdiction and knowledge graph = true
--UPDATE dsm_datasources SET typology='aggregator' WHERE id='openaire____::scholexplorer';
UPDATE dsm_datasources_eosc SET knowledge_graph = true WHERE _dnet_resource_identifier_ = 'openaire____::scholexplorer';


-- patstat has a regional jurisdiction
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::EPO', 'openaire____::EPO', 'Regional');

-- Software Heritage is an aggregator with global jurisdiction
UPDATE dsm_datasources SET typology='aggregator::softwarerepository' WHERE id='openaire____::SoftwareHeritage';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::SoftwareHeritage', 'openaire____::SoftwareHeritage', 'Global');

-- bio.tools is thematic
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, thematic)
VALUES('rest________::bioTools', 'rest________::bioTools', true);



--DRIVER is an aggregator with global jurisdiction
UPDATE dsm_datasources SET typology='aggregator::pubsrepository::unknown' WHERE id='openaire____::driver';
INSERT INTO dsm_datasources_eosc(id, _dnet_resource_identifier_, jurisdiction)
VALUES('openaire____::driver', 'openaire____::driver', 'Global');


-- FIX DOAJ journals with the proper content policies until we fix the transformation (#6970)
UPDATE dsm_datasources_eosc SET content_policies = ARRAY ['Journal articles'] where id like 'doajarticles%';
