package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class MDStoreToApiExtraFieldHadoopJobNode extends SimpleJobNode {

    private String mdId;
    private String datasourceId;
    private String datasourceInterface;
    private String extraFieldForTotal;
    private String extraFieldForDate;
    private String extraFieldForMdId;

    /* Spring managed params */
    private String mdStoreManagerUrl;

    @Autowired
    private LocalDatasourceManager<?, ?> dsManager;

    private static final Log log = LogFactory.getLog(MDStoreToApiExtraFieldHadoopJobNode.class);

    @Override
    protected String execute(final NodeToken token) throws Exception {

        final String url = getMdStoreManagerUrl() + "/mdstore/{mdId}";

        final Map<String, Object> params = new HashMap<>();
        params.put("mdId", getMdId());

        final URI uri = UriComponentsBuilder.fromUriString(url)
                .buildAndExpand(params)
                .toUri();

        final RestTemplate restTemplate = new RestTemplate();
        final MDStoreWithInfo mdstore = restTemplate.getForObject(uri, MDStoreWithInfo.class);

        final int size = Math.toIntExact(mdstore.getSize());
        final Date date = mdstore.getLastUpdate();

        token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "sinkSize", size);

        if (extraFieldForTotal.equals("last_collection_total")) {
            dsManager.setLastCollectionInfo(datasourceId, datasourceInterface, mdId, size, date);
        } else if (extraFieldForTotal.equals("last_aggregation_total")) {
            dsManager.setLastAggregationInfo(datasourceId, datasourceInterface, mdId, size, date);
        } else {
            log.warn("Invalid field for total: " + extraFieldForTotal);
        }

        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return mdId;
    }

    public void setMdId(final String mdId) {
        this.mdId = mdId;
    }

    public String getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(final String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return datasourceInterface;
    }

    public void setDatasourceInterface(final String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getExtraFieldForTotal() {
        return extraFieldForTotal;
    }

    public void setExtraFieldForTotal(final String extraFieldForTotal) {
        this.extraFieldForTotal = extraFieldForTotal;
    }

    public String getExtraFieldForDate() {
        return extraFieldForDate;
    }

    public void setExtraFieldForDate(final String extraFieldForDate) {
        this.extraFieldForDate = extraFieldForDate;
    }

    public String getExtraFieldForMdId() {
        return extraFieldForMdId;
    }

    public void setExtraFieldForMdId(final String extraFieldForMdId) {
        this.extraFieldForMdId = extraFieldForMdId;
    }

    public String getMdStoreManagerUrl() {
        return mdStoreManagerUrl;
    }

    public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }

}
