/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertHostedByApisJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(UpsertHostedByApisJobNode.class);
    private static final String HOSTED_BY_COMPLIANCE = "hostedBy";
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    private String countersParam;
    private String mdId;
    public static final String extraFieldsForTotal = "last_aggregation_total";
    public static final String extraFieldForDate = "last_aggregation_date";
    public static final String extraFieldForMdId = "last_aggregation_mdId";

    protected String execute(NodeToken token) throws Exception {
        HostedByCounters counters = (HostedByCounters)token.getEnv().getTransientAttribute(this.countersParam);
        String date = DateUtils.now_ISO8601();
        String namespacePrefix = token.getEnv().getAttribute("namespacePrefix");
        log.info((Object)counters);
        for (Map.Entry<String, Integer> e : counters.getCounters().entrySet()) {
            this.updateHostedByApi(e.getKey(), namespacePrefix, date, e.getValue());
        }
        return Arc.DEFAULT_ARC;
    }

    private void updateHostedByApi(String dsId, String namepsacePrefix, String date, int size) {
        log.info((Object)("Verifying hostedBy api in ds: " + dsId));
        try {
            for (Api iface : this.dsManager.getApis(dsId)) {
                if (!HOSTED_BY_COMPLIANCE.equals(iface.getCompatibility())) continue;
                return;
            }
            Api api = new Api();
            api.setDatasource(dsId);
            api.setId("api_________::" + dsId + "::hostedBy");
            api.setCompatibility(HOSTED_BY_COMPLIANCE);
            api.setProtocol("UNKNOWN");
            api.setContentdescription("metadata");
            api.setBaseurl("");
            api.setActive(Boolean.valueOf(false));
            api.setRemovable(Boolean.valueOf(true));
            this.dsManager.addApi(api);
        }
        catch (DsmException e) {
            log.warn((Object)("Error setting hostedBy api of ds: " + dsId), (Throwable)e);
        }
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }
}

