/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.openaire.directindex.api.RecentResultsQueue;
import eu.dnetlib.openaire.directindex.utils.OafToIndexRecordFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class FeedMissingClaimsJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(FeedMissingClaimsJobNode.class);
    public static final int BATCH_SIZE = 1000;
    public static final int ATTEMPTS = 3;
    public static final int SLEEP_MS_SOLR_CLIENT = 5000;
    private RecentResultsQueue queue;
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;

    protected String execute(NodeToken nodeToken) throws Exception {
        String format = nodeToken.getEnv().hasAttribute("format") ? nodeToken.getEnv().getAttribute("format") : nodeToken.getFullEnv().getAttribute("format");
        String coll = format + "-index-openaire";
        String baseUrl = this.calculateIndexBaseUrl();
        CloudIndexClient idxClient = null;
        try {
            ArrayList<SolrInputDocument> toFeed = new ArrayList<SolrInputDocument>();
            ArrayList<String> toDeleteFromCache = new ArrayList<String>();
            SAXReader reader = new SAXReader();
            ApplyXslt xslt = this.oafToIndexRecordFactory.newTransformer(format);
            idxClient = CloudIndexClientFactory.newIndexClient((String)baseUrl, (String)coll, (boolean)false);
            log.info((Object)("Starting to feed claims in index collection " + coll));
            int count = 0;
            for (String record : this.queue) {
                int max_attempts = 3;
                ++count;
                String id = reader.read((Reader)new StringReader(record)).valueOf("//*[local-name() = 'objIdentifier']");
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processing record %s, number: %d", id, count));
                }
                if (this.isRecordIndexed(idxClient, baseUrl, coll, id, max_attempts)) {
                    toDeleteFromCache.add(id);
                } else {
                    max_attempts = 3;
                    toFeed.add(this.prepareSolrDoc(idxClient, baseUrl, coll, id, record, xslt, max_attempts));
                }
                if (count % 1000 != 0) continue;
                this.processLists(idxClient, baseUrl, coll, toFeed, toDeleteFromCache);
            }
            if (!toFeed.isEmpty() || !toDeleteFromCache.isEmpty()) {
                this.processLists(idxClient, baseUrl, coll, toFeed, toDeleteFromCache);
            }
            log.info((Object)String.format("Finished feeding of claims in index collection %s, total: %d", coll, count));
        }
        catch (Throwable e) {
            log.error((Object)"Error feeding missing claims", e);
            throw e;
        }
        finally {
            if (idxClient != null) {
                idxClient.close();
            }
            log.info((Object)"Closed Solr index client");
        }
        log.info((Object)"Now proceeding to Arc.DEFAULT_ARC");
        return Arc.DEFAULT_ARC;
    }

    protected boolean isRecordIndexed(CloudIndexClient idxClient, String baseUrl, String coll, String id, int attempt) throws IOException, CloudIndexClientException, MSROException, InterruptedException {
        try {
            return idxClient.isRecordIndexed(id);
        }
        catch (CloudIndexClientException cie) {
            log.error((Object)String.format("Error querying for %s, message: %s. Trying again, remaining attempts:", new Object[]{id, cie, attempt}));
            idxClient = this.resetCloudIndexClient(idxClient, baseUrl, coll);
            if (attempt > 0) {
                return this.isRecordIndexed(idxClient, baseUrl, coll, id, --attempt);
            }
            String msg = String.format("Too many attempts %d to recreate the index client for checking if record %s exists.", 3, id);
            log.error((Object)msg);
            throw new MSROException((Throwable)cie);
        }
    }

    protected SolrInputDocument prepareSolrDoc(CloudIndexClient idxClient, String baseUrl, String coll, String recordId, String record, ApplyXslt xslt, int attempt) throws IOException, CloudIndexClientException, MSROException, InterruptedException {
        try {
            return idxClient.prepareSolrDocument(record, (UnaryFunction)xslt);
        }
        catch (CloudIndexClientException cie) {
            log.error((Object)String.format("Error preparing Solr doc for %s, message: %s. Trying again, remaining attempts:", new Object[]{recordId, cie, attempt}));
            idxClient = this.resetCloudIndexClient(idxClient, baseUrl, coll);
            if (attempt > 0) {
                return this.prepareSolrDoc(idxClient, baseUrl, coll, recordId, record, xslt, --attempt);
            }
            String msg = String.format("Too many attempts %d to recreate the index client for preparing SolrDocument for %s", 3, this.id);
            log.error((Object)msg);
            throw new MSROException((Throwable)cie);
        }
    }

    protected void tryToFeed(CloudIndexClient idxClient, String baseUrl, String coll, List<SolrInputDocument> toFeed, int attempt) throws MSROException, IOException, CloudIndexClientException, InterruptedException {
        try {
            idxClient.feed(toFeed, null);
        }
        catch (CloudIndexClientException cie) {
            log.error((Object)String.format("Error feeding Solr in attempt number %d", attempt));
            idxClient = this.resetCloudIndexClient(idxClient, baseUrl, coll);
            if (attempt > 0) {
                this.tryToFeed(idxClient, baseUrl, coll, toFeed, --attempt);
            }
            String msg = String.format("Too many attempts %d to recreate the index client for feeding Solr", 3);
            log.error((Object)msg);
            throw new MSROException((Throwable)cie);
        }
    }

    private CloudIndexClient resetCloudIndexClient(CloudIndexClient idxClient, String baseUrl, String coll) throws IOException, CloudIndexClientException, InterruptedException {
        if (idxClient != null) {
            idxClient.close();
        }
        Thread.sleep(5000L);
        CloudIndexClient newclient = CloudIndexClientFactory.newIndexClient((String)baseUrl, (String)coll, (boolean)false);
        log.info((Object)"Got new CloudIndexClient");
        return newclient;
    }

    private void processLists(CloudIndexClient idxClient, String baseUrl, String coll, List<SolrInputDocument> toFeed, List<String> toDeleteFromCache) throws CloudIndexClientException, MSROException, IOException, InterruptedException {
        int max_attempts = 3;
        this.tryToFeed(idxClient, baseUrl, coll, toFeed, max_attempts);
        this.queue.remove(toDeleteFromCache);
        log.info((Object)String.format("%d claims fed and cache cleaned of %d records", toFeed.size(), toDeleteFromCache.size()));
        toFeed.clear();
        toDeleteFromCache.clear();
        log.info((Object)"Cleaned temporary lists");
    }

    public RecentResultsQueue getQueue() {
        return this.queue;
    }

    @Required
    public void setQueue(RecentResultsQueue queue) {
        this.queue = queue;
    }

    public OafToIndexRecordFactory getOafToIndexRecordFactory() {
        return this.oafToIndexRecordFactory;
    }

    @Required
    public void setOafToIndexRecordFactory(OafToIndexRecordFactory oafToIndexRecordFactory) {
        this.oafToIndexRecordFactory = oafToIndexRecordFactory;
    }

    private String calculateIndexBaseUrl() throws Exception {
        String query = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }
}

