package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import java.util.List;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;

/**
 * Abstract BBJob node for sending BB messages to the StatsManagerService. Subclasses must implement the prepareJob method.
 *
 * @author alessia
 */
public abstract class AbstractStatsJobNode extends BlackboardJobNode {

	private String xqueryForServiceIdParam;
	/**
	 * BB parameter defining which is the portal affected by the action. Overrides the value in the env parameter below.
	 */
	private String portal;
	/**
	 * Name of the env parameter where to find the target portal value. It is used only if the portal parameter above is not explicitly set
	 * in the workflow.
	 */
	private String portalParam;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		final String xquery = token.getEnv().getAttribute(getXqueryForServiceIdParam());
		List<String> statsServiceIds;
		try {
			statsServiceIds = getServiceLocator().getService(ISLookUpService.class).quickSearchProfile(xquery);
			if (statsServiceIds.size() > 1) throw new RuntimeException("Too many StatsManagerService ids found using query: " + xquery);
			if (statsServiceIds.size() < 1) throw new RuntimeException("StatsManagerService id not found using query: " + xquery);
			return statsServiceIds.get(0);
		} catch (ISLookUpException e) {
			throw new RuntimeException(e);
		}
	}

	public String getPortalName(final NodeToken token) {
		if (StringUtils.isNotBlank(portal)) return portal;
		else return token.getEnv().getAttribute(portalParam);
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

	public String getPortal() {
		return portal;
	}

	public void setPortal(final String portal) {
		this.portal = portal;
	}

	public String getPortalParam() {
		return portalParam;
	}

	public void setPortalParam(final String portalParam) {
		this.portalParam = portalParam;
	}

}
