/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message;

import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message.DnetMessageManager;
import eu.dnetlib.msro.rmi.MSROException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class DnetMessageManagerController {
    @Resource
    private DnetMessageManager dnetMessageManager;
    private static final Log log = LogFactory.getLog(DnetMessageManagerController.class);

    @RequestMapping(value={"/dhp/message"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseBody
    public List<String> registerMessage(@RequestBody(required=true) Message message) throws MSROException {
        this.dnetMessageManager.registerMessage(message);
        return Arrays.asList("done");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error processing http method", (Throwable)e);
        return new ErrorMessage(e);
    }

    public class ErrorMessage {
        private final String message;
        private final String stacktrace;

        public ErrorMessage(Exception e) {
            this(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }

        public ErrorMessage(String message, String stacktrace) {
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

