<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaf="http://namespace.openaire.eu/oaf"
    exclude-result-prefixes="xsl datetime exslt dnet">
    
    <xsl:variable name="status" select="/*[local-name() = 'record']/*[local-name() = 'header']/@status" />
    <xsl:variable name="datestamp" select="datetime:dateTime()" />

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test=".//oaf:entity">
                <xsl:call-template name="identity"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="default"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="identity">
        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

            <oai:header>
                <dri:dateOfCollection><xsl:value-of select="\$datestamp"/></dri:dateOfCollection>
                 <xsl:if test="not(.//oaf:datasourceprefix)">
                     <oaf:datasourceprefix>$namespacePrefix$</oaf:datasourceprefix>
                 </xsl:if>
                <xsl:for-each select="//*[local-name() = 'header']/*[local-name() != 'dateOfCollection']">
                    <xsl:copy-of select="."/>
                </xsl:for-each>
            </oai:header>
            <oai:metadata>
                <xsl:copy-of select=".//oaf:entity"/>
            </oai:metadata>
            <xsl:call-template name="about"/>
        </oai:record>
    </xsl:template>

    <xsl:template name="default">

        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

            <xsl:variable name="evaluatedMetadataId" select="normalize-space($xpath$)" />
            <oai:header>
                <xsl:if test="\$status">
                    <xsl:attribute name="status" >
                        <xsl:value-of select="\$status"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:if test="not(.//dri:objIdentifier) and not(.//*[local-name() = 'header']/*[local-name()='objIdentifier'])">
                    <xsl:if test="\$evaluatedMetadataId != ''">
                        <dri:objIdentifier><xsl:value-of select="concat('$namespacePrefix$::', dnet:md5(\$evaluatedMetadataId))"/></dri:objIdentifier>
                    </xsl:if>
                </xsl:if>
                <xsl:if test="not(.//dri:recordIdentifier)">
                    <dri:recordIdentifier><xsl:value-of select="\$evaluatedMetadataId"/></dri:recordIdentifier>
                </xsl:if>
                <xsl:if test="not(string(.//dri:dateOfCollection))">
                    <dri:dateOfCollection><xsl:value-of select="\$datestamp"/></dri:dateOfCollection>
                </xsl:if>
                <xsl:if test="not(.//oaf:datasourceprefix)">
                    <oaf:datasourceprefix>$namespacePrefix$</oaf:datasourceprefix>
                </xsl:if>

                <xsl:for-each select="/*[local-name() = 'record']/*[local-name() = 'header']/*">
                    <xsl:copy-of select="."/>
                </xsl:for-each>
            </oai:header>
            <xsl:choose>
                <xsl:when test="count(/*[local-name() = 'record']/*[local-name() = 'metadata']) &gt; 0">
                    <xsl:copy-of select="/*[local-name() = 'record']/*[local-name() = 'metadata']"/>
                </xsl:when>
                <xsl:when test="\$status = 'deleted'" />
                <xsl:otherwise>
                    <oai:metadata>
                        <xsl:copy-of select="."/>
                    </oai:metadata>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="not(\$status) or \$status != 'deleted'">
                <xsl:call-template name="about"/>
            </xsl:if>
        </oai:record>
    </xsl:template>

    <xsl:template name="about">
        <about>
            <provenance xmlns="http://www.openarchives.org/OAI/2.0/provenance" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/provenance http://www.openarchives.org/OAI/2.0/provenance.xsd">
                <originDescription harvestDate="{\$datestamp}" altered="true">
                    <baseURL>$baseurl$</baseURL>
                    <identifier><xsl:value-of select="//*[local-name()='header']/*[local-name()='identifier']"/></identifier>
                    <datestamp><xsl:value-of select="//*[local-name()='header']/*[local-name()='datestamp']"/></datestamp>
                    <metadataNamespace>$metadatanamespace$</metadataNamespace>
                    <xsl:copy-of select="//*[local-name()='provenance']/*[local-name() = 'originDescription']"/>
                </originDescription>
            </provenance>
            <oaf:datainfo>
                <oaf:inferred>$inferred$</oaf:inferred>
                <oaf:deletedbyinference>$deletedbyinference$</oaf:deletedbyinference>
                <oaf:trust>$trust$</oaf:trust>
                <oaf:inferenceprovenance>$inferenceprovenance$</oaf:inferenceprovenance>
                <oaf:provenanceaction schemename="dnet:provenanceActions" schemeid="dnet:provenanceActions" classname="$provenanceactionclassname$" classid="$provenanceactionclassid$"/>
            </oaf:datainfo>
        </about>
    </xsl:template>
    
</xsl:stylesheet>
