package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import java.util.concurrent.atomic.AtomicInteger;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Context;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.msro.rmi.MSROException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

/**
 * Created by alessia on 23/10/15.
 */
public class ApplyClaimUpdatesJobNode extends AbstractClaimsToHBASE {

	private static final Log log = LogFactory.getLog(ApplyClaimUpdatesJobNode.class);

	@Override
	protected String execute(NodeToken token) throws Exception {
		//TODO: use claim.claim_date from the claim db
		long timestamp = System.currentTimeMillis();
		setTotal(getClaimDatabaseUtils().count(getCountQuery()));

		final AtomicInteger discardedClaims = new AtomicInteger(0);
		final HadoopService hadoopService = getServiceLocator().getService(HadoopService.class);

		getClaimDatabaseUtils().query(getSql()).forEach(claim -> {
			try {
				log.debug(claim);
				String contextId = claim.getSource();
				String rowKey = getFullId(getOpenAIREType(claim.getTargetType()), claim.getTarget());

				String value = getValue(rowKey, contextId, timestamp);
				hadoopService.addHBaseColumn(getClusterName(), getTableName(), rowKey, "result", "update_" + System.nanoTime(), value);
				incrementProcessed();
			} catch (Exception e) {
				log.error("Discarding claim " + claim + ". Cause: " + e.getMessage());
				discardedClaims.incrementAndGet();
			}
		});
		log.info("Total Claim Updates: " + getTotal());
		token.getEnv().setAttribute("claimUpdatesSize", getTotal());
		log.info("Claim updates: " + getProcessed());
		token.getEnv().setAttribute("claimUpdates", getProcessed());
		log.info("Discarded Claim Updates: " + discardedClaims.intValue());
		token.getEnv().setAttribute("discardedClaimUpdates", discardedClaims.intValue());

		return Arc.DEFAULT_ARC;
	}

	protected String getValue(final String rowkey, final String contextid, final long timestamp) throws MSROException {
		log.debug(StringUtils.format("%s --  %s", rowkey, contextid));

		Result.Builder resultBuilder = Result.newBuilder().setMetadata(Result.Metadata.newBuilder().addContext(getContext(contextid)));
		OafEntity.Builder entityBuilder = OafEntity.newBuilder().setId(rowkey).setType(Type.result).setResult(resultBuilder);
		Oaf.Builder builder = Oaf.newBuilder().setKind(Kind.entity).setLastupdatetimestamp(timestamp).setEntity(entityBuilder);

		return Base64.encodeBase64String(builder.build().toByteArray());
	}

	private Context getContext(final String sourceId) {
		return Context.newBuilder().addDataInfo(getDataInfo()).setId(sourceId).build();
	}
}
