package eu.dnetlib.organizations.repository.readonly;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.view.OrganizationSimpleView;

@Repository
public interface OrganizationSimpleViewRepository extends ReadOnlyRepository<OrganizationSimpleView, String> {

	// SEARCH
	Page<OrganizationSimpleView> findByNameContainingIgnoreCase(String name, Pageable pageable);

	// SEARCH FOR USER
	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.name ilike %:text% and uc.email = :email", nativeQuery = true)
	Page<OrganizationSimpleView> findByNameForUser(String text, String email, Pageable pageable);

	// BROWSE BY COUNTRY
	@Query(value = "select country as value, count(*) as count from organizations group by country order by count desc", nativeQuery = true)
	List<BrowseEntry> browseCountries();

	// BROWSE BY COUNTRY FOR USER
	@Query(value = "select o.country as value, count(o.country) as count from user_countries uc left outer join organizations o on (uc.country = o.country) where uc.email=?1 group by o.country order by count desc", nativeQuery = true)
	List<BrowseEntry> browseCountriesForUser(String email);

	Page<OrganizationSimpleView> findByCountry(String country, Pageable pageable);

	// BROWSE BY ORG TYPE
	@Query(value = "select type as value, count(*) as count from organizations group by type order by count desc", nativeQuery = true)
	List<BrowseEntry> browseTypes();

	// BROWSE BY ORG TYPE FOR USER
	@Query(value = "select o.type as value, count(o.type) as count "
			+ "from organizations o "
			+ "left outer join user_countries uc on (uc.country = o.country) "
			+ "where uc.email=?1 "
			+ "group by o.type "
			+ "order by count desc;", nativeQuery = true)
	List<BrowseEntry> browseTypesForUser(String email);

	Page<OrganizationSimpleView> findByType(String type, Pageable pageable);

	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1", nativeQuery = true)
	Page<OrganizationSimpleView> findByTypeForUser(String type, String name, Pageable pageable);

}
