/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.SuggestionInfo;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.model.OpenaireDuplicate;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;
import eu.dnetlib.organizations.model.utils.OrganizationConflictImpl;
import eu.dnetlib.organizations.model.view.ConflictGroupView;
import eu.dnetlib.organizations.model.view.DuplicateGroupView;
import eu.dnetlib.organizations.model.view.OrganizationInfoView;
import eu.dnetlib.organizations.model.view.OrganizationSimpleView;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.repository.OpenaireConflictRepository;
import eu.dnetlib.organizations.repository.OpenaireDuplicateRepository;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.readonly.ConflictGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.DuplicateGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationInfoViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationSimpleViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationViewRepository;
import eu.dnetlib.organizations.repository.readonly.SuggestionInfoViewByCountryRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/organizations"})
public class OrganizationController {
    @Autowired
    private OrganizationViewRepository organizationViewRepository;
    @Autowired
    private OrganizationInfoViewRepository organizationInfoViewRepository;
    @Autowired
    private OrganizationSimpleViewRepository organizationSimpleViewRepository;
    @Autowired
    private OpenaireDuplicateRepository openaireDuplicateRepository;
    @Autowired
    private OpenaireConflictRepository openaireConflictRepository;
    @Autowired
    private ConflictGroupViewRepository conflictGroupViewRepository;
    @Autowired
    private SuggestionInfoViewByCountryRepository suggestionInfoViewByCountryRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private DuplicateGroupViewRepository duplicateGroupViewRepository;
    @Autowired
    private DatabaseUtils databaseUtils;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public List<String> save(@RequestBody OrganizationView org, Authentication authentication) {
        if (StringUtils.isBlank((CharSequence)org.getName())) {
            throw new RuntimeException("Missing field: name");
        }
        if (StringUtils.isBlank((CharSequence)org.getCountry())) {
            throw new RuntimeException("Missing field: country");
        }
        if (StringUtils.isBlank((CharSequence)org.getType())) {
            throw new RuntimeException("Missing field: type");
        }
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), authentication.getName())) {
            String orgId = this.databaseUtils.insertOrUpdateOrganization(org, authentication.getName(), StringUtils.isNotBlank((CharSequence)org.getId()));
            return Arrays.asList(orgId);
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public OrganizationInfoView infoById(@RequestParam String id, Authentication authentication) {
        return (OrganizationInfoView)this.organizationInfoViewRepository.findById((Object)id).get();
    }

    @RequestMapping(value={"/suggestionsInfo"}, method={RequestMethod.GET})
    public SuggestionInfo suggestionsInfo(Authentication authentication) {
        SuggestionInfo info;
        block3: {
            block4: {
                block2: {
                    info = new SuggestionInfo();
                    if (!UserInfo.isSuperAdmin((Authentication)authentication)) break block2;
                    this.suggestionInfoViewByCountryRepository.findAll().forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
                    break block3;
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block3;
            }
            this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().map(arg_0 -> ((SuggestionInfoViewByCountryRepository)this.suggestionInfoViewByCountryRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
        }
        return info;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public OrganizationView findById(@RequestParam String id, Authentication authentication) {
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)id).get();
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), authentication.getName())) {
            return org;
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/conflicts"}, method={RequestMethod.GET})
    public List<OrganizationConflict> conflicts(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName())) {
            return this.openaireConflictRepository.getConflictsForId(id);
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/duplicates"}, method={RequestMethod.GET})
    public List<OpenaireDuplicate> duplicates(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName())) {
            return this.openaireDuplicateRepository.findByLocalId(id);
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/conflicts/byCountry/{country}"}, method={RequestMethod.GET})
    public Collection<Set<OrganizationConflictImpl>> findConflictsByCountry(@PathVariable String country, Authentication authentication) {
        block5: {
            block4: {
                this.databaseUtils.verifyConflictGroups(false);
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.groupConflicts(this.conflictGroupViewRepository.findByCountry1OrCountry2(country, country).stream());
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            Stream list = this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().filter(country::equalsIgnoreCase).map(c -> this.conflictGroupViewRepository.findByCountry1OrCountry2(c, c).stream()).findFirst().orElse(Stream.empty());
            return this.groupConflicts(list);
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/duplicates/byCountry/{country}"}, method={RequestMethod.GET})
    public Iterable<DuplicateGroupView> findDuplicatesByCountry(@PathVariable String country, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.duplicateGroupViewRepository.findByCountry(country);
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            return this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().filter(country::equalsIgnoreCase).map(arg_0 -> ((DuplicateGroupViewRepository)this.duplicateGroupViewRepository).findByCountry(arg_0)).findFirst().orElse(new ArrayList());
        }
        throw new RuntimeException("User not authorized");
    }

    private Collection<Set<OrganizationConflictImpl>> groupConflicts(Stream<ConflictGroupView> stream) {
        TreeMap map = new TreeMap();
        stream.forEach(c -> {
            if (!map.containsKey(c.getGroup())) {
                map.put(c.getGroup(), new TreeSet());
            }
            ((Set)map.get(c.getGroup())).add(new OrganizationConflictImpl(c.getId1(), c.getName1(), c.getType1(), c.getCity1(), c.getCountry1()));
            ((Set)map.get(c.getGroup())).add(new OrganizationConflictImpl(c.getId2(), c.getName2(), c.getType2(), c.getCity2(), c.getCountry2()));
        });
        return map.values();
    }

    @RequestMapping(value={"/duplicates"}, method={RequestMethod.POST})
    public List<OpenaireDuplicate> duplicates(@RequestBody List<OpenaireDuplicate> simrels, Authentication authentication) {
        boolean b;
        boolean bl = b = UserInfo.isSuperAdmin((Authentication)authentication) || simrels.stream().map(OpenaireDuplicate::getLocalId).distinct().allMatch(id -> this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName()));
        if (b) {
            return this.openaireDuplicateRepository.saveAll(simrels);
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/search/{page}/{size}"}, method={RequestMethod.GET})
    public Page<OrganizationSimpleView> search(@PathVariable int page, @PathVariable int size, @RequestParam String q, Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSimpleViewRepository.findByNameContainingIgnoreCase(q, (Pageable)PageRequest.of((int)page, (int)size)) : this.organizationSimpleViewRepository.findByNameForUser(q, authentication.getName(), (Pageable)PageRequest.of((int)page, (int)size));
    }

    @RequestMapping(value={"/byCountry/{code}/{page}/{size}"}, method={RequestMethod.GET})
    public Page<OrganizationSimpleView> findByCountry(@PathVariable String code, @PathVariable int page, @PathVariable int size, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(code, authentication.getName())) {
            return this.organizationSimpleViewRepository.findByCountry(code, (Pageable)PageRequest.of((int)page, (int)size));
        }
        throw new RuntimeException("User not authorized");
    }

    @RequestMapping(value={"/byType/{type}/{page}/{size}"}, method={RequestMethod.GET})
    public Page<OrganizationSimpleView> findByType(@PathVariable String type, @PathVariable int page, @PathVariable int size, Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSimpleViewRepository.findByType(type, (Pageable)PageRequest.of((int)page, (int)size)) : this.organizationSimpleViewRepository.findByTypeForUser(type, authentication.getName(), (Pageable)PageRequest.of((int)page, (int)size));
    }

    @RequestMapping(value={"/browse/countries"}, method={RequestMethod.GET})
    public List<BrowseEntry> browseCountries(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSimpleViewRepository.browseCountries() : this.organizationSimpleViewRepository.browseCountriesForUser(authentication.getName());
    }

    @RequestMapping(value={"/browse/types"}, method={RequestMethod.GET})
    public List<BrowseEntry> browseOrganizationTypes(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSimpleViewRepository.browseTypes() : this.organizationSimpleViewRepository.browseTypesForUser(authentication.getName());
    }
}

