/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.repository.readonly;

import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.view.OrganizationSimpleView;
import eu.dnetlib.organizations.repository.readonly.ReadOnlyRepository;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface OrganizationSimpleViewRepository
extends ReadOnlyRepository<OrganizationSimpleView, String> {
    public Page<OrganizationSimpleView> findByNameContainingIgnoreCase(String var1, Pageable var2);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.name ilike %:text% and uc.email = :email", nativeQuery=true)
    public Page<OrganizationSimpleView> findByNameForUser(String var1, String var2, Pageable var3);

    @Query(value="select country as value, count(*) as count from organizations group by country order by count desc", nativeQuery=true)
    public List<BrowseEntry> browseCountries();

    @Query(value="select o.country as value, count(o.country) as count from user_countries uc left outer join organizations o on (uc.country = o.country) where uc.email=?1 group by o.country order by count desc", nativeQuery=true)
    public List<BrowseEntry> browseCountriesForUser(String var1);

    public Page<OrganizationSimpleView> findByCountry(String var1, Pageable var2);

    @Query(value="select type as value, count(*) as count from organizations group by type order by count desc", nativeQuery=true)
    public List<BrowseEntry> browseTypes();

    @Query(value="select o.type as value, count(o.type) as count from organizations o left outer join user_countries uc on (uc.country = o.country) where uc.email=?1 group by o.type order by count desc;", nativeQuery=true)
    public List<BrowseEntry> browseTypesForUser(String var1);

    public Page<OrganizationSimpleView> findByType(String var1, Pageable var2);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1", nativeQuery=true)
    public Page<OrganizationSimpleView> findByTypeForUser(String var1, String var2, Pageable var3);
}

