CREATE TEMPORARY TABLE tmp_simrels (
	local_id         text NOT NULL,
	oa_original_id   text NOT NULL,
	oa_name          text NOT NULL,
	oa_acronym       text,
	oa_country       text,
	oa_url           text,
	oa_collectedfrom text
);

COPY tmp_simrels(local_id, oa_original_id, oa_name, oa_acronym, oa_country, oa_url, oa_collectedfrom) FROM '/Users/michele/Develop/dnet45/dnet-orgs-database-application/src/main/resources/tmp_data/rels.part-r-00000.tsv' DELIMITER E'\t';;

DELETE FROM oa_duplicates WHERE reltype = 'suggested';
DELETE FROM oa_conflicts  WHERE reltype = 'suggested';
UPDATE oa_conflicts SET idgroup = NULL;

INSERT INTO oa_duplicates (local_id, oa_original_id, oa_name, oa_acronym, oa_country, oa_url, oa_collectedfrom)
SELECT local_id, oa_original_id, oa_name, oa_acronym, oa_country, oa_url, oa_collectedfrom
FROM tmp_simrels
WHERE oa_original_id NOT LIKE 'openorgs____::%'
ON CONFLICT DO NOTHING;

INSERT INTO oa_conflicts (id1, id2)
SELECT local_id, oa_original_id
FROM tmp_simrels
WHERE oa_original_id LIKE 'openorgs____::%'
ON CONFLICT DO NOTHING;
