var orgsModule = angular.module('orgs', ['ngRoute', 'checklist-model']);

orgsModule.service('vocabulariesService', function($http) {
    this.vocs = {};
    this.getVocs = function(f) {
   		if (Object.keys(this.vocs).length === 0) {
   			$http.get('api/vocabularies').then(function successCallback(res) {
   				if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
	    		this.vocs = res.data;
	    		f(angular.copy(this.vocs));
			}, function errorCallback(res) {
				alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
			});
   		} else {
   			f(this.vocs);
   		}
    };
});

orgsModule.directive('selectOrgModal', function($http) {
	return {
		restrict: 'E',
		scope: {
			'modalId'     : '@',
			'selectedOrg' : '='
		},
		templateUrl: 'resources/html/modals/select_org.html',
		link: function(scope, element, attrs, ctrl) {
			scope.searchOrgs = {};
			scope.searchValue = '';
			
			scope.search = function(text, page, size) {
				scope.searchOrgs = {};
				$http.get('api/organizations/search/' + page + '/' + size + '?q=' + text).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					scope.searchValue = text;
					scope.searchOrgs = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			}
		}
	}
});

orgsModule.directive('resolveConflictsModal', function($http) {
	return {
		restrict: 'E',
		scope: {
			'modalId'     : '@',
			'orgs'        : '=',
			'selectedOrgs': '='
		},
		templateUrl: 'resources/html/modals/resolve_conflicts.html',
		link: function(scope, element, attrs, ctrl) {
			scope.selectOrg = function(org) {
				var sel = angular.copy(org);
				if (scope.selectedOrgs.length == 0) { sel.show = 'success'; }
				else                                { sel.show = 'info'; }
				scope.selectedOrgs.push(sel); 
				org.show = 'hidden';
			}

			scope.reset = function() {
				scope.selectedOrgs = [];
				angular.forEach(scope.orgs, function(org) { org.show = 'secondary'; });
			}
			
			scope.createGroup = function() {
				alert('todo');
			}		
		}
	}
});
		
orgsModule.directive('orgTabsMenu', function($http) {
	return {
		restrict: 'E',
		scope: {
			'orgId'    : '@',
			'info'     : '=',
			'selected' : '=',
			'org'      : '=',
			'events'   : '=',
		},
		templateUrl: 'resources/html/menu/org_tabs_menu.html',
		link: function(scope, element, attrs, ctrl) {

			scope.loadOrg = function() {
				scope.org = {};
				$http.get('api/organizations/get?id=' + scope.orgId).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					scope.org = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
				scope.selected = 1;
			}
			
			scope.loadDedupEvents = function() {
				scope.events = {};

				$http.get('api/organizations/conflicts?id=' + scope.orgId).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					scope.events.conflicts = res.data;
					$http.get('api/organizations/duplicates?id=' + scope.orgId).then(function successCallback(res) {
						if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
						scope.events.duplicates = res.data;
					}, function errorCallback(res) {
						alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
					});
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
				scope.selected = 2;
			};
								
			scope.loadOrg();
		}
     }
});


orgsModule.directive('orgFormMetadata', function($http, $location, $route, $routeParams) {
	return {
		restrict: 'E',
		scope: {
			'orgId'        : '@',
			'org'          : '=',
			'vocabularies' : '=',
			'mode'         : '@',  // insert or update
			'infoMethod'   : '&'
		},
		templateUrl: 'resources/html/forms/org_metadata.html',
		link: function(scope, element, attrs, ctrl) {
			
			scope.newRelation = {};
			scope.newRelType = '';
							
			scope.resetSelectedRelation = function() {
				scope.newRelation = {};
			}
		
			scope.addNewRelation = function(r) {
				scope.org.relations.push({
					'relatedOrgId'   : scope.newRelation.id,
					'relatedOrgName' : scope.newRelation.name,
					'type'           : scope.newRelType
				});
				scope.newRelation = {};
				scope.newRelType = '';
			}
			
			scope.save = function() {
				$http.defaults.headers.post["Content-Type"] = "application/json;charset=UTF-8";
				$http.post('api/organizations/save', scope.org).then(function successCallback(res) {
					if      ((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					else if (scope.mode == 'insert')        { $location.url('/edit/1/' + res.data[0]);    }
					else if ($routeParams.msg == 2)         { $route.reload(); }
					else                                    { $location.url('/edit/2/' + res.data[0]); }
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				}); 
			}
		}
     }
});

orgsModule.directive('orgDedupEvents', function($http, $location, $route) {
	return {
		restrict: 'E',
		scope: {
			'orgId'        : '@',
			'events'       : '=',
			'vocabularies' : '=',
			'infoMethod'   : '&'
		},
		templateUrl: 'resources/html/parts/org_dedup_events.html',
		link: function(scope, element, attrs, ctrl) {
			
			scope.currentOrgDetails = {};
			
			$http.get('api/organizations/get?id=' + scope.orgId).then(function successCallback(res) {
				if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
				scope.currentOrgDetails = res.data;
			}, function errorCallback(res) {
				alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
			});
			
			scope.saveDuplicates = function() {
				$http.defaults.headers.post["Content-Type"] = "application/json;charset=UTF-8";
				$http.post('api/organizations/duplicates', scope.events.duplicates).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					if (scope.infoMethod)             { scope.infoMethod(); }
					alert('Events updated !!!');
					scope.events.duplicates = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			}
			
			scope.saveConflicts = function() {
				alert('todo');
			}
		}
     }
});


orgsModule.directive('orgDetails', function($http, $location, $route) {
	return {
		restrict: 'E',
		scope: {
			'org'      : '=',
			'orgTitle' : '@',
			'show'     : '@'
		},
		templateUrl: 'resources/html/parts/org_details.html',
		link: function(scope, element, attrs, ctrl) {}
     }
});

orgsModule.directive('orgResults', function($http, $location, $route) {
	return {
		restrict: 'E',
		scope: {
			'searchMessage' : '@',
			'orgs'          : '=',
			'nextFunction'  : '&',
			'prevFunction'  : '&',
			'selectedOrg'   : '=',
			'mode'          : '@'
		},
		templateUrl: 'resources/html/parts/org_results.html',
		link: function(scope, element, attrs, ctrl) {
			scope.selectOrg = function(o) {
				scope.selectedOrg = o;
			}
		}
     }
});


orgsModule.directive('allConflicts', function($http, $location, $route, $q) {
	return {
		restrict: 'E',
		scope: {
			'conflicts'    : '=',
			'country'      : '@',
			'info'         : '=',
			'infoMethod'   : '&'
		},
		templateUrl: 'resources/html/forms/all_conflicts.html',
		link: function(scope, element, attrs, ctrl) {
			scope.orgs = [];
			
			scope.prepareConflictsModal = function(list) {
				scope.orgs = [];
				scope.selectedOrgs = [];
				
				var gets = list.map((o) => $http.get('api/organizations/get?id=' + o.id));
				
				$q.all(gets).then(function(responses) {
					scope.orgs = responses.map((resp) => resp.data);
					angular.forEach(scope.orgs, function(org) { org.show = 'secondary'; });
				});
			}
			
		}
     }
});

orgsModule.directive('orgFormDuplicates', function($http, $location, $route) {
	return {
		restrict: 'E',
		scope: {
			'duplicates'     : '=',
			'showSaveButton' : '@',
			'saveFunction'   : '&'
		},
		templateUrl: 'resources/html/forms/org_duplicates.html',
		link: function(scope, element, attrs, ctrl) {}
     }
});

orgsModule.directive('orgFormConflicts', function($http, $location, $route, $q) {
	return {
		restrict: 'E',
		scope: {
			'orgId'          : '@',   
			'conflicts'      : '=',
			'showSaveButton' : '@',
			'saveFunction'   : '&'
		},
		templateUrl: 'resources/html/forms/org_conflicts.html',
		link: function(scope, element, attrs, ctrl) {
			scope.candidateConflicts = [];
			scope.selectedConflicts = [];
			
			scope.prepareConflictsModal = function() {
				scope.candidateConflicts = [];
				scope.selectedConflicts = [];
				
				var gets = [ $http.get('api/organizations/get?id=' + scope.orgId) ];
				angular.forEach(scope.conflicts, function(c) { gets.push($http.get('api/organizations/get?id=' + c.id)); });
				
				$q.all(gets).then(function(responses) {
					scope.candidateConflicts = responses.map((resp) => resp.data);
					angular.forEach(scope.candidateConflicts, function(org) { org.show = 'secondary'; });
				});
			}
		}
     }
});

orgsModule.directive('allDuplicates', function($http, $location, $route) {
	return {
		restrict: 'E',
		scope: {
			'duplicates'   : '=',
			'country'      : '@',
			'info'         : '=',
			'infoMethod'   : '&'
		},
		templateUrl: 'resources/html/forms/all_duplicates.html',
		link: function(scope, element, attrs, ctrl) {
			scope.currentOrg = {};
			scope.currentOrgDetails = {};
			scope.currentDuplicates = [];
			
			scope.prepareDuplicatesModal = function(org) {
				scope.currentOrg = org;
				scope.currentOrgDetails = {};
				scope.currentDuplicates = [];
				
				$http.get('api/organizations/get?id=' + org.id).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					scope.currentOrgDetails = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
				
				$http.get('api/organizations/duplicates?id=' + org.id).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					scope.currentDuplicates = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			};
			
			scope.saveCurrentDuplicates = function() {
				$http.defaults.headers.post["Content-Type"] = "application/json;charset=UTF-8";
				$http.post('api/organizations/duplicates', scope.currentDuplicates).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					if (scope.infoMethod)             { scope.infoMethod(); }
					scope.currentOrg.numberOfDuplicates = 0;
					for (var i=0; i<res.data.length; i++) {
						if (res.data[i].relType == 'suggested') {
							scope.currentOrg.numberOfDuplicates++;
						}
					}
					scope.currentDuplicates = [];
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			};
		}
    }
});

orgsModule.config(function($routeProvider) {
	$routeProvider
		.when('/new',                              { templateUrl: 'resources/html/new.html',              controller: 'newOrgCtrl' })
		.when('/search',                           { templateUrl: 'resources/html/search.html',           controller: 'searchCtrl' })
		.when('/searchResults/:page/:size/:text*', { templateUrl: 'resources/html/searchResults.html',    controller: 'searchResultsCtrl' })
		.when('/countries',                        { templateUrl: 'resources/html/browse.html',           controller: 'countriesCtrl' })
		.when('/byCountry/:page/:size/:code*',     { templateUrl: 'resources/html/resultsByCountry.html', controller: 'byCountryCtrl' })
		.when('/types',                            { templateUrl: 'resources/html/browse.html',           controller: 'typesCtrl' })
		.when('/byType/:page/:size/:type*',        { templateUrl: 'resources/html/resultsByType.html',    controller: 'byTypeCtrl' })
		.when('/edit/:msg/:id',                    { templateUrl: 'resources/html/edit.html',             controller: 'showEditCtrl' })
		.when('/suggestions/:country/:tab',        { templateUrl: 'resources/html/suggestions.html',      controller: 'showSuggestionsCtrl' })
		.when('/users',                            { templateUrl: 'resources/html/users.html',            controller: 'usersCtrl' })
		.otherwise({ redirectTo: '/suggestions/_/1' });
});

orgsModule.filter('escape', function() {
	return function(input) {
		return encodeURIComponent(encodeURIComponent(input));
	}; 
});

orgsModule.filter('unescape', function() {
	return function(input) {
		return decodeURIComponent(input);
	};
});

orgsModule.controller('newOrgCtrl', function ($scope, $http, $routeParams, $location, vocabulariesService) {
	$scope.org = {
		"id": "",
		"name": "",
		"type": null,
		"lat": 0.0,
		"lng": 0.0,
		"city": "",
		"country": "",
		"source": "user",
		"otherIdentifiers": [],
		"otherNames": [],
		"relations": [],
		"acronyms": [],
		"urls": [],
		"relations": []
	};
	
	$scope.vocabularies = {};
	vocabulariesService.getVocs(function(vocs) { $scope.vocabularies = vocs; });
	
});

orgsModule.controller('searchCtrl', function ($scope, $location) {
	$scope.searchText = '';
	$scope.search = function() {
		$location.url('/searchResults/0/50/' + encodeURIComponent(encodeURIComponent($scope.searchText)));
	}
});

orgsModule.controller('searchResultsCtrl', function ($scope, $http, $routeParams, $location) {
	$scope.searchText = decodeURIComponent($routeParams.text);
	$scope.orgs = {};
	
	$http.get('api/organizations/search/' + $routeParams.page + '/' + $routeParams.size + '?q=' + $scope.searchText).then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.orgs = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
	
	$scope.prev = function() {
		$location.url('/searchResults/' + ($scope.orgs.number - 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.searchText));
	}
	
	$scope.next = function() {
		$location.url('/searchResults/' + ($scope.orgs.number + 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.searchText));
	}
});

orgsModule.controller('countriesCtrl', function ($scope, $http, $routeParams) {
	$scope.field = 'Country';
	$scope.resultsBasePath = '/byCountry'
	$scope.entries = [];
	
	$http.get('api/organizations/browse/countries').then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.entries = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
	
});

orgsModule.controller('byCountryCtrl', function ($scope, $http, $routeParams, $location) {
	$scope.fieldValue = decodeURIComponent($routeParams.code);
	$scope.orgs = {};
	
	$http.get('api/organizations/byCountry/' + $routeParams.code + '/' + $routeParams.page + '/' + $routeParams.size).then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.orgs = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
	
	$scope.prev = function() {
		$location.url('/byCountry/' + ($scope.orgs.number - 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.fieldValue));
	}
	
	$scope.next = function() {
		$location.url('/byCountry/' + ($scope.orgs.number + 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.fieldValue));
	}

});

orgsModule.controller('typesCtrl', function ($scope, $http, $routeParams) {
	$scope.field = 'Organization type';
	$scope.resultsBasePath = '/byType'
	$scope.entries = [];
	
	$http.get('api/organizations/browse/types').then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.entries = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
	
});

orgsModule.controller('byTypeCtrl', function ($scope, $http, $routeParams, $location) {
	
	$scope.fieldValue = $routeParams.type;
	
	$scope.orgs = {};
	
	$http.get('api/organizations/byType/' + $routeParams.type + '/' + $routeParams.page + '/' + $routeParams.size).then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.orgs = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
	
	$scope.prev = function() {
		$location.url('/byType/' + ($scope.orgs.number - 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.fieldValue));
	}
	
	$scope.next = function() {
		$location.url('/byType/' + ($scope.orgs.number + 1) + '/' + $scope.orgs.size + '/' + encodeURIComponent($scope.fieldValue));
	}
});


orgsModule.controller('showEditCtrl', function ($scope, $http, $routeParams, $route, $location, $timeout, vocabulariesService) {
	$scope.orgId = $routeParams.id;
	$scope.org = {};
	$scope.events = {};
	$scope.info = {};
	
	$scope.getInfo = function() {
    	$http.get('api/organizations/info?id=' + $scope.orgId).then(function successCallback(res) {
    		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
    		$scope.info = res.data;
		}, function errorCallback(res) {
			alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
		});
    };
	
    $scope.getInfo();
	
	$scope.vocabularies = {};
	vocabulariesService.getVocs(function(vocs) { $scope.vocabularies = vocs; });
	
	if      ($routeParams.msg == 1) { $scope.message = 'New organization registered !!!'; }
	else if ($routeParams.msg == 2) { $scope.message = 'Organization updated !!!';        }
	else                            { $scope.message = '';                                }
	
	$timeout(function() { $scope.message = ''; }, 3000)
		
});

orgsModule.controller('showSuggestionsCtrl', function ($scope, $http, $routeParams, $location) {
	$scope.info = {};
	$scope.conflicts = [];
	$scope.duplicates = [];
	$scope.currentTab = $routeParams.tab;
	$scope.country = $routeParams.country;
	
	$scope.getInfo = function() {
    	$http.get('api/organizations/suggestionsInfo').then(function successCallback(res) {
    		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
    		$scope.info = res.data;
    		if ($scope.country == '_') {
    			var found = '';
    			
    			angular.forEach($scope.info.byCountry, function(values, c) {
    				if (!found && (($scope.currentTab == 1 && values.nDuplicates > 0) || ($scope.currentTab == 2 && values.nConflicts > 0))) {
    					found = c;
    				}
    			});
    			if (found) { $location.url('/suggestions/' + found + '/' + $scope.currentTab); }
    		}
 		}, function errorCallback(res) {
			alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
		});
	};
	

	$scope.refresh = function() {
		$scope.conflicts = [];
		$scope.duplicates = [];
		
		if ($scope.country != '_') {
			if ($scope.currentTab == 1) {
				$http.get('api/organizations/duplicates/byCountry/' + $scope.country).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					$scope.duplicates = res.data;
					if ($scope.duplicates.length > 0) {
						//$scope.currentCountry = $scope.duplicates.
					}
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			} else if ($scope.currentTab == 2) {
				$http.get('api/organizations/conflicts/byCountry/' + $scope.country).then(function successCallback(res) {
					if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
					$scope.conflicts = res.data;
				}, function errorCallback(res) {
					alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
				});
			} else {  }
		}
		$scope.getInfo();
	}
	
	$scope.refresh();
});


orgsModule.controller('usersCtrl', function ($scope, $http, $timeout, $route, vocabulariesService) {
	$scope.users = [];
	$scope.vocs = {};
	$scope.currentUser = {};
	$scope.superAdminMode = superAdminMode();
	
	$scope.vocabularies = {};
	vocabulariesService.getVocs(function(vocs) { $scope.vocabularies = vocs; });
	
	$http.get('api/users').then(function successCallback(res) {
		if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
		$scope.users = res.data;
	}, function errorCallback(res) {
		alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
	});
		
	$scope.setCurrentUser = function(user) {
		angular.copy(user, $scope.currentUser);
		if (!$scope.currentUser.role || $scope.currentUser.role == 'PENDING') {		
			$scope.currentUser.role = 'USER';
		}
	}
	
	$scope.saveUser = function(user) {
		$http.defaults.headers.post["Content-Type"] = "application/json;charset=UTF-8";
		$http.post('api/users', user).then(function successCallback(res) {
			if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
			$scope.users = res.data;
		}, function errorCallback(res) {
			alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
		});
	}
	
	$scope.deleteUser = function(email) {
		if (confirm("Are you sure ?")) {
			$http.delete('api/users?email=' + email).then(function successCallback(res) {
				if((typeof res.data) == 'string') { alert("Session expired !"); location.reload(true); }
				$scope.users = res.data;
			}, function errorCallback(res) {
				alert('ERROR: ' + res.data.error + ' (' + res.data.message + ')');
			});
		}
	}
});
