/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.utils;

import eu.dnetlib.organizations.controller.UserRole;
import eu.dnetlib.organizations.model.Acronym;
import eu.dnetlib.organizations.model.OpenaireConflict;
import eu.dnetlib.organizations.model.OpenaireConflictPK;
import eu.dnetlib.organizations.model.Organization;
import eu.dnetlib.organizations.model.OtherIdentifier;
import eu.dnetlib.organizations.model.OtherName;
import eu.dnetlib.organizations.model.Relationship;
import eu.dnetlib.organizations.model.Url;
import eu.dnetlib.organizations.model.User;
import eu.dnetlib.organizations.model.UserCountry;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.AcronymRepository;
import eu.dnetlib.organizations.repository.OpenaireConflictRepository;
import eu.dnetlib.organizations.repository.OrganizationRepository;
import eu.dnetlib.organizations.repository.OtherIdentifierRepository;
import eu.dnetlib.organizations.repository.OtherNameRepository;
import eu.dnetlib.organizations.repository.RelationshipRepository;
import eu.dnetlib.organizations.repository.UrlRepository;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.RelationType;
import java.time.OffsetDateTime;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class DatabaseUtils {
    @Autowired
    private AcronymRepository acronymRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private OtherIdentifierRepository otherIdentifierRepository;
    @Autowired
    private OtherNameRepository otherNameRepository;
    @Autowired
    private UrlRepository urlRepository;
    @Autowired
    private RelationshipRepository relationshipRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private OpenaireConflictRepository openaireConflictRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Transactional
    public String insertOrUpdateOrganization(OrganizationView orgView, String user, boolean update) {
        if (update) {
            this.cleanOldRelations(orgView.getId());
        }
        Organization org = new Organization(update ? orgView.getId() : null, orgView.getName(), orgView.getType(), orgView.getLat(), orgView.getLng(), orgView.getCity(), orgView.getCountry());
        String orgId = ((Organization)this.organizationRepository.save((Object)org)).getId();
        this.makeNewRelations(orgView, orgId);
        this.updateHistoryFields(orgId, user, update);
        return orgId;
    }

    private void updateHistoryFields(String id, String user, boolean update) {
        OffsetDateTime now = OffsetDateTime.now();
        if (update) {
            this.organizationRepository.updateModificationDate(id, user, now);
        } else {
            this.organizationRepository.updateCreationDate(id, user, now);
            this.organizationRepository.updateModificationDate(id, user, now);
        }
    }

    private void makeNewRelations(OrganizationView orgView, String orgId) {
        orgView.getAcronyms().forEach(s -> {
            Acronym cfr_ignored_0 = (Acronym)this.acronymRepository.save((Object)new Acronym(orgId, s));
        });
        orgView.getOtherNames().forEach(n -> {
            OtherName cfr_ignored_0 = (OtherName)this.otherNameRepository.save((Object)new OtherName(orgId, n.getName(), n.getLang()));
        });
        orgView.getOtherIdentifiers().forEach(id -> {
            OtherIdentifier cfr_ignored_0 = (OtherIdentifier)this.otherIdentifierRepository.save((Object)new OtherIdentifier(orgId, id.getId(), id.getType()));
        });
        orgView.getUrls().forEach(u -> {
            Url cfr_ignored_0 = (Url)this.urlRepository.save((Object)new Url(orgId, u));
        });
        orgView.getRelations().forEach(r -> {
            Relationship r1 = new Relationship(orgId, r.getRelatedOrgId(), r.getType());
            Relationship r2 = new Relationship(r.getRelatedOrgId(), orgId, RelationType.valueOf((String)r.getType()).getInverse().toString());
            this.relationshipRepository.save((Object)r1);
            this.relationshipRepository.save((Object)r2);
            if (r.getType().equals(RelationType.Merged_In.toString()) || r.getType().equals(RelationType.Merges.toString())) {
                this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(orgId, r.getRelatedOrgId())).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
                this.openaireConflictRepository.findById((Object)new OpenaireConflictPK(r.getRelatedOrgId(), orgId)).ifPresent(arg_0 -> ((OpenaireConflictRepository)this.openaireConflictRepository).delete(arg_0));
            }
        });
    }

    private void cleanOldRelations(String id) {
        this.acronymRepository.deleteByOrgId(id);
        this.otherNameRepository.deleteByOrgId(id);
        this.otherIdentifierRepository.deleteByOrgId(id);
        this.urlRepository.deleteByOrgId(id);
        this.relationshipRepository.deleteById1(id);
        this.relationshipRepository.deleteById2(id);
    }

    @Cacheable(value={"vocs"})
    public List<String> listValuesOfVocabularyTable(VocabularyTable table) {
        return this.jdbcTemplate.queryForList("select val from " + table, String.class);
    }

    @Cacheable(value={"countries_for_user"})
    public List<String> listCountriesForUser(String name) {
        return this.jdbcTemplate.queryForList("select country from user_countries where email = ?", String.class, new Object[]{name});
    }

    @Transactional
    public void saveUser(@RequestBody UserView userView) {
        User user = (User)this.userRepository.findById((Object)userView.getEmail()).orElseThrow(() -> new RuntimeException("User not found"));
        user.setRole(userView.getRole());
        user.setValid(userView.isValid());
        this.userRepository.save((Object)user);
        this.userCountryRepository.deleteByEmail(userView.getEmail());
        if (userView.getCountries() != null) {
            this.userCountryRepository.saveAll((Iterable)Arrays.stream(userView.getCountries()).map(c -> new UserCountry(userView.getEmail(), c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public void deleteUser(String email) {
        this.userCountryRepository.deleteByEmail(email);
        this.userRepository.deleteById((Object)email);
    }

    @Transactional
    public void newUser(String email, List<String> countries) {
        User user = new User();
        user.setEmail(email);
        user.setRole(UserRole.PENDING.name());
        user.setValid(false);
        this.userRepository.save((Object)user);
        if (countries != null) {
            this.userCountryRepository.saveAll((Iterable)countries.stream().map(c -> new UserCountry(email, c)).collect(Collectors.toList()));
        }
    }

    @Transactional
    public void verifyConflictGroups(boolean forceUpdate) {
        if (forceUpdate || this.openaireConflictRepository.countByGroupNull() > 0L) {
            this.openaireConflictRepository.resetGroupIds();
            HashMap<String, AbstractSet> groups = new HashMap<String, AbstractSet>();
            for (OpenaireConflict openaireConflict : this.openaireConflictRepository.findAll()) {
                String idGroup;
                List list = this.findExistingGroupsForRel(openaireConflict, groups);
                if (list.isEmpty()) {
                    idGroup = this.generateGroupId();
                    groups.put(idGroup, new HashSet());
                    this.addToGroup(groups, idGroup, openaireConflict);
                    continue;
                }
                if (list.size() == 1) {
                    this.addToGroup(groups, (String)list.get(0), openaireConflict);
                    continue;
                }
                idGroup = this.generateGroupId();
                groups.put(idGroup, new TreeSet());
                list.forEach(id -> ((Set)groups.get(idGroup)).addAll((Collection)groups.get(id)));
                list.forEach(id -> {
                    Set cfr_ignored_0 = (Set)groups.remove(id);
                });
                this.addToGroup(groups, idGroup, openaireConflict);
            }
            for (Map.Entry entry : groups.entrySet()) {
                String gid = (String)entry.getKey();
                for (String orgId : (Set)entry.getValue()) {
                    for (OpenaireConflict oc : this.openaireConflictRepository.findById1AndGroupIsNull(orgId)) {
                        oc.setGroup(gid);
                        this.openaireConflictRepository.save((Object)oc);
                    }
                    for (OpenaireConflict oc : this.openaireConflictRepository.findById2AndGroupIsNull(orgId)) {
                        oc.setGroup(gid);
                        this.openaireConflictRepository.save((Object)oc);
                    }
                }
            }
        }
    }

    private String generateGroupId() {
        return "group::" + UUID.randomUUID();
    }

    private List<String> findExistingGroupsForRel(OpenaireConflict w, Map<String, Set<String>> groups) {
        return groups.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(w.getId1()) || ((Set)e.getValue()).contains(w.getId2())).map(e -> (String)e.getKey()).distinct().collect(Collectors.toList());
    }

    private void addToGroup(Map<String, Set<String>> groups, String gid, OpenaireConflict w) {
        groups.get(gid).add(w.getId1());
        groups.get(gid).add(w.getId2());
    }
}

