/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.distance.eval.ConditionEvalMap;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.List;

public abstract class AbstractCondition
extends AbstractPaceFunctions
implements ConditionAlgo {
    protected String cond;
    protected List<FieldDef> fields;

    public AbstractCondition(String cond, List<FieldDef> fields) {
        this.cond = cond;
        this.fields = fields;
    }

    protected abstract ConditionEval verify(FieldDef var1, Field var2, Field var3, Config var4);

    @Override
    public ConditionEvalMap verify(Document a, Document b, Config conf) {
        ConditionEvalMap res = new ConditionEvalMap();
        for (FieldDef fd : this.getFields()) {
            Field va = a.values(fd.getName());
            Field vb = b.values(fd.getName());
            if (fd.isIgnoreMissing()) {
                res.put(fd.getName(), this.verify(fd, va, vb, conf));
                continue;
            }
            if (va.isEmpty() || vb.isEmpty()) {
                res.put(fd.getName(), new ConditionEval(this.cond, va, vb, -1));
                continue;
            }
            res.put(fd.getName(), this.verify(fd, va, vb, conf));
        }
        return res;
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }
}

