/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.Levenstein;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.DistanceClass;
import eu.dnetlib.pace.distance.SecondStringDistanceAlgo;
import java.util.Map;

@DistanceClass(value="LevensteinTitleIgnoreVersion")
public class LevensteinTitleIgnoreVersion
extends SecondStringDistanceAlgo {
    public LevensteinTitleIgnoreVersion(Map<String, Number> params) {
        super(params, (AbstractStringDistance)new Levenstein());
    }

    public LevensteinTitleIgnoreVersion(double w) {
        super(w, (AbstractStringDistance)new Levenstein());
    }

    protected LevensteinTitleIgnoreVersion(double w, AbstractStringDistance ssalgo) {
        super(w, ssalgo);
    }

    @Override
    public double distance(String a, String b, Config conf) {
        String ca = this.cleanup(a);
        String cb = this.cleanup(b);
        ca = ca.replaceAll("\\d", "").replaceAll(this.getRomans(ca), "").trim();
        cb = cb.replaceAll("\\d", "").replaceAll(this.getRomans(cb), "").trim();
        ca = this.filterAllStopWords(ca);
        cb = this.filterAllStopWords(cb);
        String cca = this.finalCleanup(ca);
        String ccb = this.finalCleanup(cb);
        return this.normalize(this.ssalgo.score(cca, ccb), cca.length(), ccb.length());
    }

    private double normalize(double score, int la, int lb) {
        return 1.0 - Math.abs(score) / (double)Math.max(la, lb);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return 1.0 / Math.pow(Math.abs(d) + 1.0, 0.1);
    }
}

