/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.CondDef;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.util.PaceResolver;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class PaceConfig
implements Serializable {
    private List<FieldDef> model;
    private List<CondDef> strictConditions;
    private List<CondDef> conditions;
    private List<ClusteringDef> clustering;
    private Map<String, List<String>> blacklists;
    private Map<String, List<String>> synonyms;
    @JsonIgnore
    private Map<String, String> translationMap;
    @JsonIgnore
    private Map<String, FieldDef> modelMap;
    @JsonIgnore
    public static PaceResolver resolver = new PaceResolver();

    public void initModel() {
        this.modelMap = Maps.newHashMap();
        for (FieldDef fd : this.getModel()) {
            this.modelMap.put(fd.getName(), fd);
        }
    }

    public void initTranslationMap() {
        this.translationMap = Maps.newHashMap();
        for (String key : this.synonyms.keySet()) {
            for (String term : this.synonyms.get(key)) {
                this.translationMap.put(Normalizer.normalize(term.toLowerCase(), Normalizer.Form.NFD), key);
            }
        }
    }

    public Map<String, String> translationMap() {
        return this.translationMap;
    }

    public List<FieldDef> getModel() {
        return this.model;
    }

    public void setModel(List<FieldDef> model) {
        this.model = model;
    }

    public List<CondDef> getStrictConditions() {
        return this.strictConditions;
    }

    public void setStrictConditions(List<CondDef> strictConditions) {
        this.strictConditions = strictConditions;
    }

    public List<CondDef> getConditions() {
        return this.conditions;
    }

    @JsonIgnore
    public List<ConditionAlgo> getConditionAlgos() {
        return this.asConditionAlgos(this.getConditions());
    }

    @JsonIgnore
    public List<ConditionAlgo> getStrictConditionAlgos() {
        return this.asConditionAlgos(this.getStrictConditions());
    }

    public void setConditions(List<CondDef> conditions) {
        this.conditions = conditions;
    }

    public List<ClusteringDef> getClustering() {
        return this.clustering;
    }

    public void setClustering(List<ClusteringDef> clustering) {
        this.clustering = clustering;
    }

    public Map<String, List<String>> getBlacklists() {
        return this.blacklists;
    }

    public void setBlacklists(Map<String, List<String>> blacklists) {
        this.blacklists = blacklists;
    }

    public Map<String, List<String>> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Map<String, List<String>> synonyms) {
        this.synonyms = synonyms;
    }

    public Map<String, FieldDef> getModelMap() {
        return this.modelMap;
    }

    public void setModelMap(Map<String, FieldDef> modelMap) {
        this.modelMap = modelMap;
    }

    private List<ConditionAlgo> asConditionAlgos(List<CondDef> defs) {
        ArrayList algos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(defs)) {
            return algos;
        }
        for (CondDef cd : defs) {
            List<FieldDef> fields = this.getModel().stream().filter(fd -> cd.getFields().contains(fd.getName())).collect(Collectors.toList());
            algos.add(cd.conditionAlgo(fields));
        }
        return algos;
    }
}

