/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.condition.AbstractCondition;
import eu.dnetlib.pace.condition.ConditionClass;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@ConditionClass(value="yearMatch")
public class YearMatch
extends AbstractCondition {
    private int limit = 4;

    public YearMatch(String cond, List<FieldDef> fields) {
        super(cond, fields);
    }

    @Override
    protected ConditionEval verify(FieldDef fd, Field a, Field b, Config conf) {
        String valueA = this.getNumbers(this.getFirstValue(a));
        String valueB = this.getNumbers(this.getFirstValue(b));
        boolean lengthMatch = this.checkLength(valueA) && this.checkLength(valueB);
        boolean onemissing = valueA.isEmpty() || valueB.isEmpty();
        return new ConditionEval(this.cond, a, b, lengthMatch && valueA.equals(valueB) || onemissing ? 1 : -1);
    }

    protected boolean checkLength(String s) {
        return s.length() == this.limit;
    }

    @Override
    protected String getFirstValue(Field value) {
        return value != null && !value.isEmpty() ? StringUtils.left((String)value.stringValue(), (int)this.limit) : "";
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + super.toString();
    }
}

