/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.adaptor;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.pace.model.adaptor.PidOafSerialiser;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pid {
    private static final Log log = LogFactory.getLog(Pid.class);
    private String value;
    private String type;

    public static List<Pid> fromOafJson(List<String> json) {
        log.debug((Object)String.format("\nPid: %s", json));
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(Pid.class, (Object)new PidOafSerialiser());
        final Gson gson = gb.create();
        return Lists.newArrayList((Iterable)Iterables.transform(json, (Function)new Function<String, Pid>(){

            public Pid apply(String s) {
                return (Pid)gson.fromJson(s, Pid.class);
            }
        }));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

